/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.httpcomponents;

import com.gooddata.http.client.GoodDataHttpClient;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.http.client.SimpleSSTRetrievalStrategy;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.service.GoodDataEndpoint;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.httpcomponents.SingleEndpointGoodDataRestProvider;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.HttpHost;

public final class SstGoodDataRestProvider
extends SingleEndpointGoodDataRestProvider {
    public SstGoodDataRestProvider(GoodDataEndpoint endpoint, GoodDataSettings settings, String sst) {
        super(endpoint, settings, (HttpClientBuilder b, GoodDataEndpoint e, GoodDataSettings s) -> SstGoodDataRestProvider.createHttpClient(b, e, sst));
    }

    public static HttpClient createHttpClient(HttpClientBuilder builder, GoodDataEndpoint endpoint, String sst) {
        Validate.notNull((Object)endpoint, (String)"endpoint");
        Validate.notNull((Object)builder, (String)"builder");
        Validate.notNull((Object)sst, (String)"sst");
        CloseableHttpClient httpClient = builder.build();
        SimpleSSTRetrievalStrategy strategy = new SimpleSSTRetrievalStrategy(sst);
        HttpHost httpHost = new HttpHost(endpoint.getProtocol(), endpoint.getHostname(), endpoint.getPort());
        return new GoodDataHttpClient((HttpClient)httpClient, httpHost, (SSTRetrievalStrategy)strategy);
    }
}

