/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.cookie;

import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.conn.util.PublicSuffixMatcher;
import com.gooddata.shadowed.http4.cookie.CommonCookieAttributeHandler;
import com.gooddata.shadowed.http4.cookie.Cookie;
import com.gooddata.shadowed.http4.cookie.CookieOrigin;
import com.gooddata.shadowed.http4.cookie.CookieSpec;
import com.gooddata.shadowed.http4.cookie.CookieSpecProvider;
import com.gooddata.shadowed.http4.cookie.MalformedCookieException;
import com.gooddata.shadowed.http4.impl.cookie.BasicCommentHandler;
import com.gooddata.shadowed.http4.impl.cookie.BasicDomainHandler;
import com.gooddata.shadowed.http4.impl.cookie.BasicExpiresHandler;
import com.gooddata.shadowed.http4.impl.cookie.BasicMaxAgeHandler;
import com.gooddata.shadowed.http4.impl.cookie.BasicPathHandler;
import com.gooddata.shadowed.http4.impl.cookie.BasicSecureHandler;
import com.gooddata.shadowed.http4.impl.cookie.DefaultCookieSpec;
import com.gooddata.shadowed.http4.impl.cookie.NetscapeDraftSpec;
import com.gooddata.shadowed.http4.impl.cookie.PublicSuffixDomainFilter;
import com.gooddata.shadowed.http4.impl.cookie.RFC2109DomainHandler;
import com.gooddata.shadowed.http4.impl.cookie.RFC2109Spec;
import com.gooddata.shadowed.http4.impl.cookie.RFC2109VersionHandler;
import com.gooddata.shadowed.http4.impl.cookie.RFC2965CommentUrlAttributeHandler;
import com.gooddata.shadowed.http4.impl.cookie.RFC2965DiscardAttributeHandler;
import com.gooddata.shadowed.http4.impl.cookie.RFC2965DomainAttributeHandler;
import com.gooddata.shadowed.http4.impl.cookie.RFC2965PortAttributeHandler;
import com.gooddata.shadowed.http4.impl.cookie.RFC2965Spec;
import com.gooddata.shadowed.http4.impl.cookie.RFC2965VersionAttributeHandler;
import com.gooddata.shadowed.http4.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultCookieSpecProvider
implements CookieSpecProvider {
    private final CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private final String[] datepatterns;
    private final boolean oneHeader;
    private volatile CookieSpec cookieSpec;

    public DefaultCookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher, String[] datepatterns, boolean oneHeader) {
        this.compatibilityLevel = compatibilityLevel != null ? compatibilityLevel : CompatibilityLevel.DEFAULT;
        this.publicSuffixMatcher = publicSuffixMatcher;
        this.datepatterns = datepatterns;
        this.oneHeader = oneHeader;
    }

    public DefaultCookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this(compatibilityLevel, publicSuffixMatcher, null, false);
    }

    public DefaultCookieSpecProvider(PublicSuffixMatcher publicSuffixMatcher) {
        this(CompatibilityLevel.DEFAULT, publicSuffixMatcher, null, false);
    }

    public DefaultCookieSpecProvider() {
        this(CompatibilityLevel.DEFAULT, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CookieSpec create(HttpContext context) {
        if (this.cookieSpec == null) {
            DefaultCookieSpecProvider defaultCookieSpecProvider = this;
            synchronized (defaultCookieSpecProvider) {
                if (this.cookieSpec == null) {
                    String[] stringArray;
                    RFC2965Spec strict = new RFC2965Spec(this.oneHeader, new RFC2965VersionAttributeHandler(), new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new RFC2965DomainAttributeHandler(), this.publicSuffixMatcher), new RFC2965PortAttributeHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new RFC2965CommentUrlAttributeHandler(), new RFC2965DiscardAttributeHandler());
                    RFC2109Spec obsoleteStrict = new RFC2109Spec(this.oneHeader, new RFC2109VersionHandler(), new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new RFC2109DomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler());
                    CommonCookieAttributeHandler[] commonCookieAttributeHandlerArray = new CommonCookieAttributeHandler[5];
                    commonCookieAttributeHandlerArray[0] = PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher);
                    commonCookieAttributeHandlerArray[1] = this.compatibilityLevel == CompatibilityLevel.IE_MEDIUM_SECURITY ? new BasicPathHandler(){

                        @Override
                        public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                        }
                    } : new BasicPathHandler();
                    commonCookieAttributeHandlerArray[2] = new BasicSecureHandler();
                    commonCookieAttributeHandlerArray[3] = new BasicCommentHandler();
                    if (this.datepatterns != null) {
                        stringArray = (String[])this.datepatterns.clone();
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "EEE, dd-MMM-yy HH:mm:ss z";
                    }
                    commonCookieAttributeHandlerArray[4] = new BasicExpiresHandler(stringArray);
                    NetscapeDraftSpec netscapeDraft = new NetscapeDraftSpec(commonCookieAttributeHandlerArray);
                    this.cookieSpec = new DefaultCookieSpec(strict, obsoleteStrict, netscapeDraft);
                }
            }
        }
        return this.cookieSpec;
    }

    public static enum CompatibilityLevel {
        DEFAULT,
        IE_MEDIUM_SECURITY;

    }
}

