/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.cookie;

import com.gooddata.shadowed.http4.HeaderElement;
import com.gooddata.shadowed.http4.NameValuePair;
import com.gooddata.shadowed.http4.ParseException;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.message.BasicHeaderElement;
import com.gooddata.shadowed.http4.message.BasicNameValuePair;
import com.gooddata.shadowed.http4.message.ParserCursor;
import com.gooddata.shadowed.http4.message.TokenParser;
import com.gooddata.shadowed.http4.util.Args;
import com.gooddata.shadowed.http4.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.BitSet;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class NetscapeDraftHeaderParser {
    public static final NetscapeDraftHeaderParser DEFAULT = new NetscapeDraftHeaderParser();
    private static final char PARAM_DELIMITER = ';';
    private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET(61, 59);
    private static final BitSet VALUE_DELIMS = TokenParser.INIT_BITSET(59);
    private final TokenParser tokenParser = TokenParser.INSTANCE;

    public HeaderElement parseHeader(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        NameValuePair nvp = this.parseNameValuePair(buffer, cursor);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair param = this.parseNameValuePair(buffer, cursor);
            params.add(param);
        }
        return new BasicHeaderElement(nvp.getName(), nvp.getValue(), params.toArray(new NameValuePair[params.size()]));
    }

    private NameValuePair parseNameValuePair(CharArrayBuffer buffer, ParserCursor cursor) {
        String name = this.tokenParser.parseToken(buffer, cursor, TOKEN_DELIMS);
        if (cursor.atEnd()) {
            return new BasicNameValuePair(name, null);
        }
        char delim = buffer.charAt(cursor.getPos());
        cursor.updatePos(cursor.getPos() + 1);
        if (delim != '=') {
            return new BasicNameValuePair(name, null);
        }
        String value = this.tokenParser.parseToken(buffer, cursor, VALUE_DELIMS);
        if (!cursor.atEnd()) {
            cursor.updatePos(cursor.getPos() + 1);
        }
        return new BasicNameValuePair(name, value);
    }
}

