/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.pool;

import com.gooddata.shadowed.http4.HttpClientConnection;
import com.gooddata.shadowed.http4.HttpHost;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.config.ConnectionConfig;
import com.gooddata.shadowed.http4.config.SocketConfig;
import com.gooddata.shadowed.http4.impl.pool.BasicConnFactory;
import com.gooddata.shadowed.http4.impl.pool.BasicPoolEntry;
import com.gooddata.shadowed.http4.params.HttpParams;
import com.gooddata.shadowed.http4.pool.AbstractConnPool;
import com.gooddata.shadowed.http4.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

