/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.generator;

import com.googlecode.jpattern.org.cojen.classfile.ClassFile;
import com.googlecode.jpattern.orm.IOrmPersistor;
import com.googlecode.jpattern.orm.exception.OrmConfigurationException;
import com.googlecode.jpattern.orm.generator.CojenPersistorDump;
import com.googlecode.jpattern.orm.generator.IPersistorGenerator;
import com.googlecode.jpattern.orm.generator.ThreadClassLoader;
import com.googlecode.jpattern.orm.mapper.IClassMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class CojenPersistorGenerator<T>
implements IPersistorGenerator<T> {
    private static String generatedPackage = CojenPersistorGenerator.class.getPackage() + "/generated_" + new Date().getTime() + "/";
    private final IClassMapper<T> classMapper;

    public CojenPersistorGenerator(IClassMapper<T> classMapper) {
        this.classMapper = classMapper;
    }

    @Override
    public IOrmPersistor<T> generate() throws SecurityException, NoSuchMethodException, OrmConfigurationException, IOException, InstantiationException, IllegalAccessException {
        String className = generatedPackage + this.classMapper.getClass().getSimpleName() + "_" + this.getClass().getSimpleName() + "_" + new Date().getTime();
        ClassFile cf = new CojenPersistorDump<T>(className, this.classMapper).createClassFile();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        cf.writeTo((OutputStream)out);
        ThreadClassLoader classLoader = new ThreadClassLoader();
        Class<?> result = classLoader.define(className.replace('/', '.'), out.toByteArray());
        return (IOrmPersistor)result.newInstance();
    }
}

