/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.query;

import com.googlecode.jpattern.orm.IOrmClassTool;
import com.googlecode.jpattern.orm.IOrmClassToolMap;
import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.exception.OrmNotUniqueResultException;
import com.googlecode.jpattern.orm.query.ABaseOrmQuery;
import com.googlecode.jpattern.orm.query.INameSolver;
import com.googlecode.jpattern.orm.query.INameSolverConsumer;
import com.googlecode.jpattern.orm.query.IOrmQuery;
import com.googlecode.jpattern.orm.query.Join;
import com.googlecode.jpattern.orm.query.NullNameSolver;
import com.googlecode.jpattern.orm.session.IResultSetReader;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import com.googlecode.jpattern.orm.session.ISqlPerformer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OrmQuery<T>
extends ABaseOrmQuery
implements IOrmQuery<T>,
INameSolverConsumer {
    private INameSolver nameSolver = new NullNameSolver();
    private final IOrmClassToolMap ormClassToolMap;
    private final Class<T> clazz;
    private final Class<?>[] joinClasses;
    private boolean distinct;
    private final ISessionSqlPerformer session;

    public OrmQuery(IOrmClassToolMap ormClassToolMap, ISessionSqlPerformer session, Class<T> clazz, Class<?> ... joinClasses) {
        this.ormClassToolMap = ormClassToolMap;
        this.session = session;
        this.clazz = clazz;
        this.joinClasses = joinClasses;
        this.setJoin(new Join(ormClassToolMap));
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
        this.where().setNameSolver(nameSolver);
        this.orderBy().setNameSolver(nameSolver);
        this.join().setNameSolver(nameSolver);
    }

    @Override
    public List<T> findList() {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        final IOrmClassTool<T> ormClassTool = this.ormClassToolMap.getOrmClassTool(this.clazz);
        IResultSetReader resultSetReader = new IResultSetReader<List<T>>(){

            @Override
            public List<T> read(ResultSet resultSet) throws SQLException {
                ArrayList resultList = new ArrayList();
                int rowCount = 0;
                while (resultSet.next()) {
                    resultList.add(ormClassTool.getOrmPersistor().mapRow("", resultSet, rowCount++));
                }
                return resultList;
            }
        };
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return (List)sqlExec.query(this.renderSql(), resultSetReader, values.toArray());
    }

    @Override
    public long findRowCount() {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForLong(this.getGeneratedRowCountSql(), values.toArray());
    }

    @Override
    public T findUnique() throws OrmNotUniqueResultException {
        int oldMaxRow = this.getMaxRows();
        this.setMaxRows(2);
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        List<T> result = this.findList();
        this.setMaxRows(oldMaxRow);
        if (result.size() == 0) {
            throw new OrmNotUniqueResultException("The query execution returned no rows; 1 row expected");
        }
        if (result.size() > 1) {
            throw new OrmNotUniqueResultException("The query execution returned a number of rows higher than 1");
        }
        return result.get(0);
    }

    @Override
    public String getGeneratedRowCountSql() {
        StringBuffer stringBuffer = new StringBuffer();
        this.renderSelectRowCount(stringBuffer);
        this.renderFrom(stringBuffer);
        this.renderWhere(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public IOrmQuery<T> setDistinct() {
        this.distinct = true;
        return this;
    }

    private void renderSelectRowCount(StringBuffer stringBuffer) {
        stringBuffer.append("SELECT COUNT(*) ");
    }

    @Override
    protected void renderSelect(StringBuffer stringBuffer) {
        String alias = this.nameSolver.alias(this.clazz);
        stringBuffer.append("SELECT ");
        if (this.distinct) {
            stringBuffer.append("DISTINCT ");
        }
        stringBuffer.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getOrmCRUDQuery().getBaseSelectClause(alias + "."));
        stringBuffer.append(" ");
    }

    @Override
    protected void renderFrom(StringBuffer stringBuffer) {
        String alias = this.nameSolver.alias(this.clazz);
        stringBuffer.append("FROM ");
        stringBuffer.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getClassMapper().getTableMap().getTableNameWithSchema());
        stringBuffer.append(" ");
        stringBuffer.append(alias);
        stringBuffer.append(" ");
        this.join().renderSql(stringBuffer);
        if (this.joinClasses != null && this.joinClasses.length > 0) {
            for (Class<?> joinClass : this.joinClasses) {
                stringBuffer.append(", ");
                stringBuffer.append(this.ormClassToolMap.getOrmClassTool(joinClass).getClassMapper().getTableMap().getTableNameWithSchema());
                stringBuffer.append(" ");
                stringBuffer.append(this.nameSolver.alias(joinClass));
            }
            stringBuffer.append(" ");
        }
    }

    @Override
    protected void renderWhere(StringBuffer stringBuffer) {
        this.where().renderSql(stringBuffer);
    }

    @Override
    protected void renderOrderBy(StringBuffer stringBuffer) {
        this.orderBy().renderSql(stringBuffer);
    }

    @Override
    public boolean isDistinct() throws OrmException {
        return this.distinct;
    }
}

