/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.script;

import com.googlecode.jpattern.logger.ILogger;
import com.googlecode.jpattern.orm.logger.OrmLogger;
import com.googlecode.jpattern.orm.script.IParserCallback;
import com.googlecode.jpattern.orm.session.ISession;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import com.googlecode.jpattern.orm.session.ISqlPerformer;
import com.googlecode.jpattern.orm.session.ITransaction;

public class SessionParserCallback
implements IParserCallback {
    private final ISession session;
    private int parseCount = 0;
    private ITransaction tx;
    private boolean committed = false;
    private final ISqlPerformer sqlExec;
    private final int commitEveryStatements;
    private final ILogger logger;

    public SessionParserCallback(ISessionSqlPerformer session, int commitEveryStatements) {
        this.session = session;
        this.commitEveryStatements = commitEveryStatements;
        this.logger = OrmLogger.getOrmLogger(this.getClass());
        this.sqlExec = session.sqlPerformer();
        this.open();
    }

    void open() {
        this.commit();
        this.logger.debug("open", "Start new Transaction");
        this.tx = this.session.beginTransaction();
        this.committed = false;
    }

    @Override
    public void parseAction(String sqlStatement) {
        this.logger.trace("parseAction", "Execute statement " + this.parseCount + ": " + sqlStatement);
        this.sqlExec.update(sqlStatement, new Object[0]);
        ++this.parseCount;
        if (this.parseCount >= this.commitEveryStatements) {
            this.commit();
            this.open();
        }
    }

    void commit() {
        if (this.tx != null && !this.committed) {
            this.logger.debug("open", "Commit Transaction");
            this.tx.commit();
            this.committed = true;
        }
    }
}

