/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.session.datasource;

import com.googlecode.jpattern.orm.IOrmClassToolMap;
import com.googlecode.jpattern.orm.mapper.DBTableMapBuilder;
import com.googlecode.jpattern.orm.mapper.ITableMap;
import com.googlecode.jpattern.orm.session.ISession;
import com.googlecode.jpattern.orm.session.ISessionProvider;
import com.googlecode.jpattern.orm.session.datasource.DataSourceSession;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceSessionProvider
implements ISessionProvider {
    private final DataSource dataSource;

    public DataSourceSessionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public ISession getSession(IOrmClassToolMap ormClassToolMap) {
        return new DataSourceSession(this.dataSource, ormClassToolMap);
    }

    @Override
    public void updateTableMap(ITableMap tableMap, boolean enableDBScan) throws SQLException {
        new DBTableMapBuilder(this.dataSource.getConnection(), tableMap, enableDBScan).updateTableMap();
    }
}

