/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.session.jdbctemplate;

import com.googlecode.jpattern.orm.IOrmClassToolMap;
import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.session.ASession;
import com.googlecode.jpattern.orm.session.ISqlPerformer;
import com.googlecode.jpattern.orm.session.ITransaction;
import com.googlecode.jpattern.orm.session.jdbctemplate.JdbcTemplateSqlPerformer;
import com.googlecode.jpattern.orm.session.jdbctemplate.JdbcTemplateTransaction;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class JdbcTemplateSession
extends ASession {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformTransactionManager platformTransactionManager;

    public JdbcTemplateSession(JdbcTemplate jdbcTemplate, PlatformTransactionManager platformTransactionManager, IOrmClassToolMap ormClassToolMap) {
        super(ormClassToolMap);
        this.jdbcTemplate = jdbcTemplate;
        this.platformTransactionManager = platformTransactionManager;
    }

    @Override
    public ITransaction beginTransaction() throws OrmException {
        try {
            return new JdbcTemplateTransaction(this.platformTransactionManager);
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    @Override
    public void close() throws OrmException {
    }

    @Override
    public ISqlPerformer sqlPerformer() throws OrmException {
        return new JdbcTemplateSqlPerformer(this.jdbcTemplate);
    }
}

