/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.response;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import graphql.language.BooleanValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.GraphQLScalarType;
import java.io.IOException;
import java.util.ArrayList;

public abstract class AbstractCustomJacksonDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;
    AbstractCustomJacksonDeserializer<?> itemDeserializer;
    final GraphQLScalarType graphQLScalarType;
    final boolean list;
    final Class<?> handledType;

    protected AbstractCustomJacksonDeserializer(Class<?> handledType, GraphQLScalarType graphQLScalarType) {
        this(null, false, handledType, graphQLScalarType);
    }

    protected AbstractCustomJacksonDeserializer(AbstractCustomJacksonDeserializer<?> itemDeserializer, boolean list, Class<?> handledType, GraphQLScalarType graphQLScalarType) {
        super(handledType);
        this.itemDeserializer = itemDeserializer;
        this.list = list;
        this.handledType = handledType;
        this.graphQLScalarType = graphQLScalarType;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        FloatValue value;
        if (p.currentToken().equals((Object)JsonToken.VALUE_NULL)) {
            return null;
        }
        if (this.list) {
            if (!p.currentToken().equals((Object)JsonToken.START_ARRAY)) {
                throw new JsonParseException(p, "Found a " + p.currentToken().asString() + " token, but the current deserializer expects a list");
            }
            ArrayList<Object> returnedList = new ArrayList<Object>();
            while (!p.nextToken().equals((Object)JsonToken.END_ARRAY)) {
                if (p.currentToken().equals((Object)JsonToken.START_ARRAY)) {
                    if (this.itemDeserializer == null) {
                        throw new JsonParseException(p, "Found a " + p.currentToken().asString() + " JSON token, but the itemDeserializer is not defined. This JSON token can not be handled.");
                    }
                    if (!this.itemDeserializer.list) {
                        throw new JsonParseException(p, "Found a " + p.currentToken().asString() + " JSON token, but the itemDeserializer doesn't manage list. Hint: The number of embedded lists doesn't match the defined deserializer for the GraphQL field.");
                    }
                    returnedList.add(this.itemDeserializer.deserialize(p, ctxt));
                    continue;
                }
                if (this.itemDeserializer != null) {
                    if (p.currentToken().equals((Object)JsonToken.VALUE_NULL)) {
                        returnedList.add(null);
                        continue;
                    }
                    if (this.itemDeserializer.list) {
                        throw new JsonParseException(p, "Found a " + p.currentToken().asString() + " JSON token, but the itemDeserializer expects a list. Hint: the number of embedded lists doesn't match the defined deserializer for the GraphQL field.");
                    }
                    returnedList.add(this.itemDeserializer.deserialize(p, ctxt));
                    continue;
                }
                Object o = p.readValueAs(this.handledType);
                returnedList.add(o);
            }
            return (T)returnedList;
        }
        if (this.itemDeserializer != null) {
            return (T)this.itemDeserializer.deserialize(p, ctxt);
        }
        if (this.graphQLScalarType == null) {
            throw new JsonParseException(p, "Having to parse a " + p.currentToken() + ", but there is no graphQLScalarType defined");
        }
        switch (p.currentToken()) {
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                BooleanValue returnedList = new BooleanValue(p.getBooleanValue());
            }
            case VALUE_NUMBER_FLOAT: {
                value = new FloatValue(p.getDecimalValue());
                break;
            }
            case VALUE_NUMBER_INT: {
                value = new IntValue(p.getBigIntegerValue());
                break;
            }
            case VALUE_STRING: {
                value = new StringValue(p.getText());
                break;
            }
            case VALUE_NULL: {
                value = null;
                break;
            }
            default: {
                throw new JsonParseException(p, "Non managed JSON token: " + p.currentToken());
            }
        }
        if (value == null) {
            return null;
        }
        return (T)this.graphQLScalarType.getCoercing().parseLiteral((Object)value);
    }
}

