/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.PublicSpi;
import graphql.Scalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.constraints.DirectiveConstraint;
import graphql.validation.rules.ValidationEnvironment;
import graphql.validation.util.DirectivesAndTypeWalker;
import graphql.validation.util.Util;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@PublicSpi
public abstract class AbstractDirectiveConstraint
implements DirectiveConstraint {
    private final String name;

    public AbstractDirectiveConstraint(String name) {
        this.name = name;
    }

    public String toString() {
        return "@" + this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String getMessageTemplate() {
        return "graphql.validation." + this.getName() + ".message";
    }

    @Override
    public boolean appliesTo(GraphQLFieldDefinition fieldDefinition, GraphQLFieldsContainer fieldsContainer) {
        return false;
    }

    @Override
    public boolean appliesTo(GraphQLArgument argument, GraphQLFieldDefinition fieldDefinition, GraphQLFieldsContainer fieldsContainer) {
        boolean suitable = new DirectivesAndTypeWalker().isSuitable(argument, (inputType, directive) -> {
            boolean hasNamedDirective = directive.getName().equals(this.getName());
            if (hasNamedDirective) {
                boolean appliesToType = this.appliesToType(inputType = Util.unwrapNonNull(inputType));
                if (appliesToType) {
                    return true;
                }
                String argType = GraphQLTypeUtil.simplePrint((GraphQLType)inputType);
                Assert.assertTrue((boolean)false, () -> String.format("The directive rule '%s' cannot be placed on elements of type '%s'", "@" + this.getName(), argType));
            }
            return false;
        });
        return suitable;
    }

    protected abstract boolean appliesToType(GraphQLInputType var1);

    protected abstract List<GraphQLError> runConstraint(ValidationEnvironment var1);

    @Override
    public List<GraphQLError> runValidation(ValidationEnvironment validationEnvironment) {
        if (validationEnvironment.getValidatedElement() == ValidationEnvironment.ValidatedElement.FIELD) {
            return this.runFieldValidationImpl(validationEnvironment);
        }
        Object validatedValue = validationEnvironment.getValidatedValue();
        if (validatedValue == null) {
            return Collections.emptyList();
        }
        GraphQLInputType inputType = Util.unwrapNonNull(validationEnvironment.getValidatedType());
        validationEnvironment = validationEnvironment.transform(b -> b.validatedType(inputType));
        return this.runValidationImpl(validationEnvironment, inputType, validatedValue);
    }

    private List<GraphQLError> runFieldValidationImpl(ValidationEnvironment validationEnvironment) {
        return this.runConstraintOnDirectives(validationEnvironment);
    }

    private List<GraphQLError> runValidationImpl(ValidationEnvironment validationEnvironment, GraphQLInputType inputType, Object validatedValue) {
        return this.runConstraintOnDirectives(validationEnvironment);
    }

    private List<GraphQLError> runConstraintOnDirectives(ValidationEnvironment validationEnvironment) {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        List<GraphQLDirective> directives = validationEnvironment.getDirectives();
        directives = Util.sort(directives, GraphQLDirective::getName);
        for (GraphQLDirective directive : directives) {
            boolean isOurDirective = directive.getName().equals(this.getName());
            if (!isOurDirective) continue;
            validationEnvironment = validationEnvironment.transform(b -> b.context(GraphQLDirective.class, directive));
            List<GraphQLError> ruleErrors = this.runConstraint(validationEnvironment);
            errors.addAll(ruleErrors);
        }
        return errors;
    }

    protected boolean isOneOfTheseTypes(GraphQLInputType inputType, GraphQLScalarType ... scalarTypes) {
        GraphQLInputType type = Util.unwrapNonNull(inputType);
        if (type instanceof GraphQLNamedInputType) {
            GraphQLNamedInputType unwrappedType = (GraphQLNamedInputType)type;
            for (GraphQLScalarType scalarType : scalarTypes) {
                if (!unwrappedType.getName().equals(scalarType.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected int getIntArg(GraphQLDirective directive, String argName) {
        GraphQLArgument argument = directive.getArgument(argName);
        if (argument == null) {
            return (Integer)this.assertExpectedArgType(argName, "Int");
        }
        Number value = (Number)GraphQLArgument.getArgumentValue((GraphQLArgument)argument);
        if (value == null && (value = (Number)GraphQLArgument.getArgumentDefaultValue((GraphQLArgument)argument)) == null) {
            return (Integer)this.assertExpectedArgType(argName, "Int");
        }
        return value.intValue();
    }

    protected String getStrArg(GraphQLDirective directive, String argName) {
        GraphQLArgument argument = directive.getArgument(argName);
        if (argument == null) {
            return (String)this.assertExpectedArgType(argName, "String");
        }
        String value = (String)GraphQLArgument.getArgumentValue((GraphQLArgument)argument);
        if (value == null && (value = (String)GraphQLArgument.getArgumentDefaultValue((GraphQLArgument)argument)) == null) {
            return (String)this.assertExpectedArgType(argName, "String");
        }
        return value;
    }

    protected boolean getBoolArg(GraphQLDirective directive, String argName) {
        GraphQLArgument argument = directive.getArgument(argName);
        if (argument == null) {
            return (Boolean)this.assertExpectedArgType(argName, "Boolean");
        }
        Object value = GraphQLArgument.getArgumentValue((GraphQLArgument)argument);
        if (value == null && (value = GraphQLArgument.getArgumentDefaultValue((GraphQLArgument)argument)) == null) {
            return (Boolean)this.assertExpectedArgType(argName, "Boolean");
        }
        return Boolean.parseBoolean(String.valueOf(value));
    }

    protected String getMessageTemplate(GraphQLDirective directive) {
        String msg = null;
        GraphQLArgument arg = directive.getArgument("message");
        if (arg != null && (msg = (String)GraphQLArgument.getArgumentValue((GraphQLArgument)arg)) == null) {
            msg = (String)GraphQLArgument.getArgumentDefaultValue((GraphQLArgument)arg);
        }
        if (msg == null) {
            msg = "graphql.validation." + this.getName() + ".message";
        }
        return msg;
    }

    protected Map<String, Object> mkMessageParams(Object validatedValue, ValidationEnvironment validationEnvironment, Object ... args) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("validatedValue", validatedValue);
        params.put("constraint", this.getName());
        params.put("path", validationEnvironment.getValidatedPath());
        params.putAll(Util.mkMap(args));
        return params;
    }

    protected List<GraphQLError> mkError(ValidationEnvironment validationEnvironment, GraphQLDirective directive, Map<String, Object> msgParams) {
        String messageTemplate = this.getMessageTemplate(directive);
        GraphQLError error = validationEnvironment.getInterpolator().interpolate(messageTemplate, msgParams, validationEnvironment);
        return Collections.singletonList(error);
    }

    protected boolean isStringOrIDOrList(GraphQLInputType inputType) {
        return this.isStringOrID(inputType) || GraphQLTypeUtil.isList((GraphQLType)inputType);
    }

    protected boolean isStringOrIDOrListOrMap(GraphQLInputType inputType) {
        GraphQLInputType unwrappedType = Util.unwrapOneAndAllNonNull(inputType);
        return this.isStringOrID(inputType) || GraphQLTypeUtil.isList((GraphQLType)inputType) || unwrappedType instanceof GraphQLInputObjectType;
    }

    protected boolean isStringOrID(GraphQLInputType inputType) {
        GraphQLInputType unwrappedType = Util.unwrapNonNull(inputType);
        return Scalars.GraphQLString.equals((Object)unwrappedType) || Scalars.GraphQLID.equals((Object)unwrappedType);
    }

    protected Map asMap(Object value) {
        Assert.assertTrue((boolean)(value instanceof Map), () -> "The argument value MUST be a Map value");
        return (Map)value;
    }

    protected BigDecimal asBigDecimal(Object value) throws NumberFormatException {
        if (value == null) {
            return (BigDecimal)Assert.assertShouldNeverHappen((String)"Validation cant handle null objects BigDecimals", (Object[])new Object[0]);
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        String bdStr = "";
        if (value instanceof Number) {
            bdStr = value.toString();
        } else if (value instanceof String) {
            bdStr = value.toString();
        } else {
            Assert.assertShouldNeverHappen((String)"Validation cant handle objects of type '%s' as BigDecimals", (Object[])new Object[]{value.getClass().getSimpleName()});
        }
        return new BigDecimal(bdStr);
    }

    protected boolean asBoolean(Object value) {
        if (value == null) {
            return (Boolean)Assert.assertShouldNeverHappen((String)"Validation cant handle null objects Booleans", (Object[])new Object[0]);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return (Boolean)Assert.assertShouldNeverHappen((String)"Validation cant handle objects of type '%s' as Booleans", (Object[])new Object[]{value.getClass().getSimpleName()});
    }

    protected int getStringOrIDOrObjectOrMapLength(GraphQLInputType inputType, Object value) {
        int valLen = value == null ? 0 : (this.isStringOrID(inputType) ? String.valueOf(value).length() : (GraphQLTypeUtil.isList((GraphQLType)inputType) ? this.getListLength(value) : this.getObjectLen(value)));
        return valLen;
    }

    private int getObjectLen(Object value) {
        if (value == null) {
            return 0;
        }
        Map map = this.asMap(value);
        return map.size();
    }

    private int getListLength(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Iterable) {
            int len = 0;
            for (Object ignored : (Iterable)value) {
                ++len;
            }
            return len;
        }
        if (value != null && value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 0;
    }

    private <T> T assertExpectedArgType(String argName, String typeName) {
        return (T)Assert.assertShouldNeverHappen((String)"A validation directive MUST have a '%s' argument of type '%s' with a default value", (Object[])new Object[]{argName, typeName});
    }
}

