/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints.standard;

import graphql.GraphQLError;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLScalarType;
import graphql.validation.constraints.AbstractDirectiveConstraint;
import graphql.validation.constraints.GraphQLScalars;
import graphql.validation.rules.ValidationEnvironment;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

abstract class AbstractPositiveNegativeConstraint
extends AbstractDirectiveConstraint {
    public AbstractPositiveNegativeConstraint(String name) {
        super(name);
    }

    @Override
    public boolean appliesToType(GraphQLInputType inputType) {
        return this.isOneOfTheseTypes(inputType, GraphQLScalars.GRAPHQL_NUMBER_TYPES);
    }

    public List<GraphQLScalarType> getApplicableTypes() {
        return GraphQLScalars.GRAPHQL_NUMBER_TYPES;
    }

    @Override
    protected List<GraphQLError> runConstraint(ValidationEnvironment validationEnvironment) {
        boolean isOK;
        Object validatedValue = validationEnvironment.getValidatedValue();
        try {
            BigDecimal bigDecimal = this.asBigDecimal(validatedValue);
            isOK = this.isOK(bigDecimal);
        }
        catch (NumberFormatException nfe) {
            isOK = false;
        }
        if (!isOK) {
            return this.mkError(validationEnvironment, new Object[0]);
        }
        return Collections.emptyList();
    }

    protected abstract boolean isOK(BigDecimal var1);

    @Override
    protected boolean appliesToListElements() {
        return true;
    }
}

