/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.schema.GraphQLInputType;

public class GraphQLInputObjectField {
    private final String name;
    private final String description;
    private GraphQLInputType type;
    private final Object defaultValue;

    public GraphQLInputObjectField(String name, GraphQLInputType type) {
        this(name, null, type, null);
    }

    public GraphQLInputObjectField(String name, String description, GraphQLInputType type, Object defaultValue) {
        Assert.assertNotNull(name, "name can't be null");
        Assert.assertNotNull(type, "type can't be null");
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public GraphQLInputType getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public static Builder newInputObjectField() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private Object defaultValue;
        private GraphQLInputType type;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder type(GraphQLInputType type) {
            this.type = type;
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public GraphQLInputObjectField build() {
            return new GraphQLInputObjectField(this.name, this.description, this.type, this.defaultValue);
        }
    }
}

