/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.Field;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

public class FieldsOnCorrectType
extends AbstractRule {
    public FieldsOnCorrectType(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkField(Field field) {
        GraphQLCompositeType parentType = this.getValidationContext().getParentType();
        if (parentType == null) {
            return;
        }
        GraphQLFieldDefinition fieldDef = this.getValidationContext().getFieldDef();
        if (fieldDef == null) {
            String message = String.format("Field %s is undefined", field.getName());
            this.addError(new ValidationError(ValidationErrorType.FieldUndefined, field.getSourceLocation(), message));
        }
    }
}

