/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategy;
import graphql.execution.RxExecutionResult;
import graphql.language.Field;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class RxExecutionStrategy
extends ExecutionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(RxExecutionStrategy.class);

    public ExecutionResult execute(ExecutionContext executionContext, GraphQLObjectType parentType, Object source, Map<String, List<Field>> fields) {
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (String fieldName : fields.keySet()) {
            List<Field> fieldList = fields.get(fieldName);
            ExecutionResult executionResult = this.resolveField(executionContext, parentType, source, fieldList);
            if (executionResult instanceof RxExecutionResult) {
                RxExecutionResult rxResult = (RxExecutionResult)executionResult;
                Observable unwrapped = rxResult.getDataObservable().flatMap(potentialResult -> {
                    if (potentialResult instanceof RxExecutionResult) {
                        return ((RxExecutionResult)potentialResult).getDataObservable();
                    }
                    if (potentialResult instanceof ExecutionResult) {
                        return Observable.just((Object)((ExecutionResult)potentialResult).getData());
                    }
                    return Observable.just((Object)potentialResult);
                });
                observables.add(Observable.zip((Observable)Observable.just((Object)fieldName), (Observable)unwrapped, Pair::of));
                continue;
            }
            observables.add(Observable.just((Object)Pair.of((Object)fieldName, (Object)(executionResult != null ? executionResult.getData() : null))));
        }
        Observable result = Observable.merge(observables).toMap(Pair::getLeft, Pair::getRight);
        return new RxExecutionResult(result, (Observable<List<GraphQLError>>)Observable.just((Object)executionContext.getErrors()));
    }

    protected ExecutionResult completeValue(ExecutionContext executionContext, GraphQLType fieldType, List<Field> fields, Object result) {
        if (result instanceof Observable) {
            return new RxExecutionResult(((Observable)result).map(r -> super.completeValue(executionContext, fieldType, fields, r)), null);
        }
        return super.completeValue(executionContext, fieldType, fields, result);
    }

    protected ExecutionResult completeValueForList(ExecutionContext executionContext, GraphQLList fieldType, List<Field> fields, List<Object> result) {
        Observable resultObservable = Observable.from((Object[])IntStream.range(0, result.size()).mapToObj(idx -> new ListTuple(idx, result.get(idx))).toArray(ListTuple[]::new)).flatMap(tuple -> {
            ExecutionResult executionResult = this.completeValue(executionContext, fieldType.getWrappedType(), fields, tuple.result);
            if (executionResult instanceof RxExecutionResult) {
                return Observable.zip((Observable)Observable.just((Object)tuple.index), ((RxExecutionResult)executionResult).getDataObservable(), (x$0, x$1) -> new ListTuple((int)x$0, x$1));
            }
            return Observable.just((Object)new ListTuple(tuple.index, executionResult.getData()));
        }).toList().map(listTuples -> listTuples.stream().sorted(Comparator.comparingInt(x -> x.index)).map(x -> x.result).collect(Collectors.toList()));
        return new RxExecutionResult(resultObservable, null);
    }

    private class ListTuple {
        public int index;
        public Object result;

        public ListTuple(int index, Object result) {
            this.index = index;
            this.result = result;
        }
    }
}

