/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver;

import com.kttdevelopment.simplehttpserver.Record;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class FileRecord
extends Record {
    private final String fileName;
    private final String contentType;
    private final byte[] bytes;

    FileRecord(Map.Entry<String, Map> entry) {
        super(entry);
        Record.Header header = Objects.requireNonNull(this.getHeader("Content-Disposition"));
        this.fileName = Objects.requireNonNull(header.getParameter("filename"));
        header = Objects.requireNonNull(this.getHeader("Content-Type"));
        this.contentType = Objects.requireNonNull(header.getHeaderValue());
        this.bytes = this.getValue().getBytes(StandardCharsets.UTF_8);
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        return "FileRecord{name='" + this.getName() + "', fileName='" + this.fileName + "', contentType='" + this.contentType + "', value='" + Arrays.toString(this.bytes) + "', headers=" + this.getHeaders() + "}";
    }
}

