/*
 * Decompiled with CFR 0.152.
 */
package com.nappingcoder.jutil.http;

import com.nappingcoder.jutil.http.HttpUrlBuilderException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.net.URLCodec;

public final class HttpUrlBuilder {
    private static final String CHAR_SET = "UTF-8";
    private StringBuilder _query = new StringBuilder();
    private StringBuilder _path = new StringBuilder();
    private URLCodec codec = new URLCodec();
    private String _protocol;
    private String _host = "";
    private int _port;

    public static HttpUrlBuilder httpBuilder() {
        return new HttpUrlBuilder(false);
    }

    public static HttpUrlBuilder httpSecureBuilder() {
        return new HttpUrlBuilder(true);
    }

    private HttpUrlBuilder(boolean https) {
        this._protocol = https ? "https" : "http";
    }

    public HttpUrlBuilder host(String host) throws HttpUrlBuilderException {
        if (host == null) {
            throw new HttpUrlBuilderException("given host is null");
        }
        this._host = host;
        return this;
    }

    public HttpUrlBuilder port(int port) throws HttpUrlBuilderException {
        if (port <= 0 || port > 65535) {
            throw new HttpUrlBuilderException(port + " is not a valid port");
        }
        this._port = port;
        return this;
    }

    public HttpUrlBuilder path(String path) throws HttpUrlBuilderException {
        String[] elements;
        if (path == null) {
            throw new HttpUrlBuilderException("given path is null");
        }
        this._path.setLength(0);
        for (String elt : elements = path.split("/")) {
            if (elt.isEmpty()) continue;
            try {
                this._path.append(this.codec.encode(elt, CHAR_SET)).append("/");
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpUrlBuilderException("unsupported char set (you really shouldn't see this though..)", e);
            }
        }
        return this;
    }

    public HttpUrlBuilder addPathElement(String element) throws HttpUrlBuilderException {
        try {
            this._path.append(this.codec.encode(element, CHAR_SET)).append("/");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpUrlBuilderException("unsupported char set (you really shouldn't see this though..)", e);
        }
        return this;
    }

    public HttpUrlBuilder addQuery(String name, String value) throws HttpUrlBuilderException {
        try {
            this._query.append(this.codec.encode(name, CHAR_SET)).append("=").append(this.codec.encode(value, CHAR_SET)).append("&");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpUrlBuilderException("unsupported char set (you really shouldn't see this though...)", e);
        }
        return this;
    }

    public HttpUrlBuilder addQuery(Map<String, String> nvPair) throws HttpUrlBuilderException {
        if (nvPair == null) {
            return this;
        }
        Set<String> names = nvPair.keySet();
        for (String n : names) {
            String v = nvPair.get(n);
            if (v == null) {
                v = "";
            }
            this.addQuery(n, v);
        }
        return this;
    }

    public String toUrlString() {
        if (this._host == null) {
            throw new IllegalArgumentException("host must be set ");
        }
        return this.toString();
    }

    public String toString() {
        StringBuilder url = new StringBuilder();
        url.append(this._protocol).append("://").append(this._host);
        if (this._port > 0) {
            url.append(":" + this._port);
        }
        if (this._path.length() > 0) {
            if (this._path.length() > 0 && this._path.charAt(this._path.length() - 1) == '/') {
                this._path.setLength(this._path.length() - 1);
            }
            url.append("/").append((CharSequence)this._path);
        }
        if (this._query.length() > 0) {
            url.append("?").append((CharSequence)this._query);
        }
        if (url.charAt(url.length() - 1) == '&') {
            url.setLength(url.length() - 1);
        }
        return url.toString();
    }
}

