/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.inject.servlet.GuiceFilter;
import com.nesscomputing.httpserver.HttpConnector;
import com.nesscomputing.httpserver.HttpServer;
import com.nesscomputing.httpserver.HttpServerConfig;
import com.nesscomputing.lifecycle.guice.OnStage;
import com.nesscomputing.logging.Log;
import java.io.File;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public abstract class AbstractJetty8HttpServer
implements HttpServer {
    private static final Log LOG = Log.findLog();
    private static final EnumSet<DispatcherType> EMPTY_DISPATCHES = EnumSet.noneOf(DispatcherType.class);
    private final HttpServerConfig httpServerConfig;
    private final Servlet catchallServlet;
    private MBeanServer mbeanServer = null;
    private Set<Handler> handlers = null;
    private Set<Handler> loggingHandlers = null;
    private HandlerWrapper securityHandler = null;
    private GuiceFilter guiceFilter = null;
    private Server server = null;

    @Inject
    protected AbstractJetty8HttpServer(HttpServerConfig httpServerConfig, @Named(value="_catchall") Servlet catchallServlet) {
        this.httpServerConfig = httpServerConfig;
        this.catchallServlet = catchallServlet;
    }

    @Inject(optional=true)
    void setGuiceFilter(GuiceFilter guiceFilter) {
        this.guiceFilter = guiceFilter;
    }

    @Inject(optional=true)
    void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @Inject(optional=true)
    void addHandlers(@Named(value="_handlers") Set<Handler> handlers) {
        this.handlers = handlers;
    }

    @Inject(optional=true)
    void addLoggingHandlers(@Named(value="_logging") Set<Handler> loggingHandlers) {
        this.loggingHandlers = loggingHandlers;
    }

    @Inject(optional=true)
    void setSecurityHandlers(@Named(value="_security") HandlerWrapper securityHandler) {
        this.securityHandler = securityHandler;
    }

    @Override
    @OnStage(value="start")
    public void start() {
        Preconditions.checkState((this.server == null ? 1 : 0) != 0, (Object)"Server was already started!");
        Server server = new Server();
        server.setSendServerVersion(false);
        if (this.httpServerConfig.getShutdownTimeout() != null) {
            server.setStopAtShutdown(true);
            server.setGracefulShutdown(Ints.saturatedCast((long)this.httpServerConfig.getShutdownTimeout().getMillis()));
        }
        this.buildConnectors(server);
        HandlerCollection handlerCollection = new HandlerCollection();
        if (this.handlers != null) {
            for (Handler handler : this.handlers) {
                handlerCollection.addHandler(handler);
            }
        }
        handlerCollection.addHandler((Handler)this.createGuiceContext());
        if (this.loggingHandlers != null) {
            for (Handler loggingHandler : this.loggingHandlers) {
                handlerCollection.addHandler(loggingHandler);
            }
        }
        StatisticsHandler statsHandler = new StatisticsHandler();
        if (this.securityHandler == null) {
            statsHandler.setHandler((Handler)handlerCollection);
        } else {
            LOG.info("Enabling security handler (%s)", new Object[]{this.securityHandler.getClass().getName()});
            this.securityHandler.setHandler((Handler)handlerCollection);
            statsHandler.setHandler((Handler)this.securityHandler);
        }
        server.setHandler((Handler)statsHandler);
        QueuedThreadPool threadPool = new QueuedThreadPool(this.httpServerConfig.getMaxThreads());
        threadPool.setMinThreads(this.httpServerConfig.getMinThreads());
        threadPool.setMaxIdleTimeMs(this.httpServerConfig.getThreadMaxIdletime());
        server.setThreadPool((ThreadPool)threadPool);
        if (this.mbeanServer != null && this.httpServerConfig.isJmxEnabled()) {
            MBeanContainer mbeanContainer = new MBeanContainer(this.mbeanServer){

                public void doStart() {
                }
            };
            server.getContainer().addEventListener((Container.Listener)mbeanContainer);
        }
        this.server = server;
        try {
            server.start();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Preconditions.checkState((boolean)server.isRunning(), (Object)"Server did not start");
    }

    private void buildConnectors(Server server) {
        HashSet connectors = Sets.newHashSet();
        for (Map.Entry<String, HttpConnector> entry : this.getConnectors().entrySet()) {
            SelectChannelConnector jettyConnector;
            String connectorName = entry.getKey();
            HttpConnector connector = entry.getValue();
            if (connectors.contains(connector)) {
                LOG.warn("Multiple configurations for '%s', skipping", new Object[]{connector});
                continue;
            }
            connectors.add(connector);
            if (connector.isSecure()) {
                SslContextFactory sslContextFactory = new SslContextFactory(SslContextFactory.DEFAULT_KEYSTORE_PATH);
                if (this.httpServerConfig.getSSLKeystorePath() != null) {
                    sslContextFactory.setKeyStoreType(this.httpServerConfig.getSSLKeystoreType());
                    sslContextFactory.setKeyStorePath(this.httpServerConfig.getSSLKeystorePath());
                    sslContextFactory.setKeyStorePassword(this.httpServerConfig.getSSLKeystorePassword());
                }
                jettyConnector = new SslSelectChannelConnector(sslContextFactory);
            } else {
                jettyConnector = new SelectChannelConnector();
            }
            jettyConnector.setPort(connector.getPort());
            jettyConnector.setHost(connector.getAddress());
            connector.setJettyConnector((Connector)jettyConnector);
            jettyConnector.setStatsOn(true);
            jettyConnector.setForwarded(this.httpServerConfig.isForwarded());
            jettyConnector.setMaxIdleTime(this.httpServerConfig.getMaxIdletime());
            jettyConnector.setResponseHeaderSize(this.httpServerConfig.getResponseHeaderSize());
            LOG.debug("Adding connector [%s] as %s", new Object[]{connectorName, connector});
            server.addConnector((Connector)jettyConnector);
        }
    }

    @Override
    @OnStage(value="stop")
    public void stop() {
        Preconditions.checkNotNull((Object)this.server, (Object)"Server was never started!");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Preconditions.checkState((boolean)this.server.isStopped(), (Object)"Server did not stop");
        this.server = null;
    }

    private ServletContextHandler createGuiceContext() {
        ServletContextHandler context = new ServletContextHandler(0);
        File basePath = this.httpServerConfig.getServletContextBasePath();
        if (basePath != null && basePath.exists() && basePath.canRead() && basePath.isDirectory()) {
            context.setResourceBase(basePath.getAbsolutePath());
        }
        if (this.guiceFilter != null) {
            FilterHolder filterHolder = new FilterHolder((Filter)this.guiceFilter);
            context.addFilter(filterHolder, "/*", EMPTY_DISPATCHES);
        }
        ServletHolder servletHolder = new ServletHolder(this.catchallServlet);
        context.addServlet(servletHolder, "/*");
        return context;
    }

    @Override
    public abstract Map<String, HttpConnector> getConnectors();

    @Override
    public int getInternalHttpPort() {
        HttpConnector connector = this.getConnectors().get("internal-http");
        if (connector == null || !"http".equals(connector.getScheme())) {
            return -1;
        }
        return connector.getPort();
    }

    @Override
    public int getInternalHttpsPort() {
        HttpConnector connector = this.getConnectors().get("internal-https");
        if (connector == null || !"https".equals(connector.getScheme())) {
            return -1;
        }
        return connector.getPort();
    }

    @Override
    public int getExternalHttpPort() {
        HttpConnector connector = this.getConnectors().get("external-http");
        if (connector == null || !"http".equals(connector.getScheme())) {
            return -1;
        }
        return connector.getPort();
    }

    @Override
    public int getExternalHttpsPort() {
        HttpConnector connector = this.getConnectors().get("external-https");
        if (connector == null || !"https".equals(connector.getScheme())) {
            return -1;
        }
        return connector.getPort();
    }

    @Override
    public String getInternalAddress() {
        HttpConnector connector = (HttpConnector)ObjectUtils.firstNonNull((Object[])new HttpConnector[]{this.getConnectors().get("internal-http"), this.getConnectors().get("internal-https")});
        return connector == null ? null : connector.getAddress();
    }

    @Override
    public String getExternalAddress() {
        HttpConnector connector = (HttpConnector)ObjectUtils.firstNonNull((Object[])new HttpConnector[]{this.getConnectors().get("external-http"), this.getConnectors().get("external-https")});
        return connector == null ? null : connector.getAddress();
    }
}

