/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.jetty.server.Connector;

public class HttpConnector {
    private final boolean secure;
    private final int port;
    private final String address;
    private final String scheme;
    private final AtomicReference<Connector> connectorHolder = new AtomicReference<Object>(null);
    private transient int hashCode;
    private transient String toString;

    public HttpConnector(boolean secure, @Nonnull String scheme, @Nonnull String address, int port) {
        Preconditions.checkNotNull((Object)scheme, (Object)"the scheme can not be null");
        Preconditions.checkNotNull((Object)address, (Object)"the address can not be null");
        this.secure = secure;
        this.scheme = scheme;
        this.address = address;
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    void setJettyConnector(Connector connector) {
        this.connectorHolder.set(connector);
    }

    public int getPort() {
        if (this.port != 0) {
            return this.port;
        }
        Connector connector = this.connectorHolder.get();
        if (connector != null) {
            Preconditions.checkState((connector.getLocalPort() > 0 ? 1 : 0) != 0, (Object)"no port was set and the connector is not yet started!");
            return connector.getLocalPort();
        }
        return 0;
    }

    public String getAddress() {
        return this.address;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HttpConnector)) {
            return false;
        }
        HttpConnector castOther = (HttpConnector)other;
        return new EqualsBuilder().append(this.secure, castOther.secure).append(this.port, castOther.port).append((Object)this.address, (Object)castOther.address).append((Object)this.scheme, (Object)castOther.scheme).isEquals();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = new HashCodeBuilder().append(this.secure).append(this.port).append((Object)this.address).append((Object)this.scheme).toHashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.scheme + "://" + this.address + ":" + this.port + " (" + (this.secure ? "secure" : "not secure") + ")";
        }
        return this.toString;
    }
}

