/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.model.basic.jexl;

import com.nosolojava.fsm.impl.model.basic.jexl.JexlFSMEngine;
import com.nosolojava.fsm.impl.model.basic.jexl.JexlMapFSMContextInstance;
import com.nosolojava.fsm.impl.model.basic.jexl.SerializableMapContext;
import com.nosolojava.fsm.impl.runtime.basic.BasicEvent;
import com.nosolojava.fsm.model.StateMachineModel;
import com.nosolojava.fsm.model.config.exception.ConfigurationException;
import com.nosolojava.fsm.model.datamodel.Data;
import com.nosolojava.fsm.model.datamodel.DataModel;
import com.nosolojava.fsm.model.datamodel.URLDataHandler;
import com.nosolojava.fsm.model.state.State;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.ContextInstance;
import com.nosolojava.fsm.runtime.Event;
import com.nosolojava.fsm.runtime.SerializableContextInstance;
import com.nosolojava.fsm.runtime.StateMachineEngine;
import com.nosolojava.fsm.runtime.executable.externalcomm.IOProcessor;
import com.nosolojava.fsm.runtime.executable.externalcomm.InvokeHandler;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.Script;

public class JexlFSMContext
implements Context {
    public static final String SERIALIZATION_FILENAME_PATTERN = "com.nosolojava.fsm.context.{0}";
    protected final MessageFormat serializationFilenameMF = new MessageFormat("com.nosolojava.fsm.context.{0}");
    private transient Logger logger = Logger.getLogger(this.getClass().getName());
    protected final String sessionId;
    protected final String parentSessionId;
    protected final StateMachineModel model;
    protected final Queue<Event> externalEventQueue = new LinkedBlockingQueue<Event>();
    protected final Queue<Event> internalEventQueue = new LinkedBlockingQueue<Event>();
    protected final Set<String> activeInvokeSessions = new HashSet<String>();
    private final SerializableMapContext runtimeContext;
    private final SortedSet<State> activeStates = new ConcurrentSkipListSet<State>();
    private final SortedSet<State> statesToInvoke = new ConcurrentSkipListSet<State>();
    private final ConcurrentMap<String, State> states = new ConcurrentHashMap<String, State>();
    private final Map<String, URLDataHandler> dataHandlers = new ConcurrentHashMap<String, URLDataHandler>();
    private transient JexlEngine jexl;
    private SerializableContextInstance lastKnownConfiguration = null;
    private transient StateMachineEngine engine;
    public static final MessageFormat IN_EXPRESSION = new MessageFormat("In(''{0}'')");

    public static final String getEventName() {
        return "_event";
    }

    public JexlFSMContext(String sessionId, String parentSessionId, StateMachineModel model, StateMachineEngine engine, Map<String, Serializable> initValues) throws ConfigurationException {
        this.sessionId = sessionId == null ? UUID.randomUUID().toString() : sessionId;
        this.parentSessionId = parentSessionId;
        this.model = model;
        this.engine = engine;
        this.jexl = new JexlFSMEngine(this);
        this.runtimeContext = new SerializableMapContext();
        this.loadRootState(model.getRootState(), initValues);
    }

    private void loadRootState(State rootState, Map<String, Serializable> initValues) throws ConfigurationException {
        String statename = rootState.getName();
        this.checkRepeteadId(statename);
        this.states.put(statename, rootState);
        if (rootState.getDataModel() != null) {
            for (Data data : rootState.getDataModel().getDataList()) {
                this.checkRepeteadId(data.getId());
                this.registerData(data);
            }
        }
        if (initValues != null && initValues.size() > 0) {
            for (Map.Entry entry : initValues.entrySet()) {
                this.updateDataIfExists((String)entry.getKey(), entry.getValue());
            }
        }
        for (State state : rootState.getChildrens()) {
            this.loadState(state);
        }
    }

    private void loadState(State state) throws ConfigurationException {
        String statename = state.getName();
        this.checkRepeteadId(statename);
        this.states.put(statename, state);
        if (state.getDataModel() != null) {
            for (Data data : state.getDataModel().getDataList()) {
                this.checkRepeteadId(data.getId());
            }
        }
        if (state.hasChildrens()) {
            for (State aux : state.getChildrens()) {
                this.loadState(aux);
            }
        }
    }

    private void checkRepeteadId(String id) throws ConfigurationException {
        if (this.runtimeContext.has(id) || this.states.containsKey(id)) {
            throw new ConfigurationException("Ids repeated not allowed {0} ", new Object[]{id});
        }
    }

    public void clearAndSetURLDataHandlers(List<URLDataHandler> dataHandlers) {
        dataHandlers.clear();
        this.addURLDataHandlers(dataHandlers);
    }

    public void addURLDataHandlers(List<URLDataHandler> dataHandlers) {
        for (URLDataHandler handler : dataHandlers) {
            this.addURLDataHandler(handler);
        }
    }

    public void addURLDataHandler(URLDataHandler handler) {
        this.dataHandlers.put(handler.getProtocol(), handler);
    }

    public void loadDataModel(DataModel dataModel) {
        for (Data data : dataModel.getDataList()) {
            this.registerData(data);
        }
    }

    public void removeDatamodel(DataModel dataModel) {
        for (Data data : dataModel.getDataList()) {
            this.runtimeContext.set(data.getId(), null);
        }
    }

    private void registerData(Data data) {
        String id = data.getId();
        this.runtimeContext.set(id, data.evaluateData((Context)this));
    }

    public void setCurrentEvent(Event event) {
        this.runtimeContext.set("_event", event);
    }

    public Event getCurrentEvent() {
        return (Event)this.runtimeContext.get("_event");
    }

    public <T> T getDataByName(String name) {
        Object result = this.runtimeContext.get(name);
        return (T)result;
    }

    public <T> T getDataByExpression(String expression) {
        Expression e;
        try {
            e = this.jexl.createExpression(expression);
        }
        catch (NullPointerException ex) {
            this.logger.log(Level.SEVERE, String.format("Error evaluating expresion %s", expression), ex);
            return null;
        }
        Object data = e.evaluate((JexlContext)this.runtimeContext);
        return (T)data;
    }

    public boolean evaluateConditionGuardExpresion(String expression) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "evaluateConditionGuardExpresion({0})", new Object[]{expression});
            this.logger.log(Level.FINEST, "" + this.runtimeContext.get("breadcrumb"));
        }
        Expression e = this.jexl.createExpression(expression);
        Boolean result = (Boolean)e.evaluate((JexlContext)this.runtimeContext);
        return result;
    }

    private void validateBeanExistInContext(String name) {
        if (!this.runtimeContext.has(name)) {
            throw new RuntimeException(String.format("Updating bean not found in datamodel, bean name: %s, active states: %s", name, this.getActiveStates()));
        }
    }

    public SortedSet<State> getActiveStates() {
        return new TreeSet<State>(this.activeStates);
    }

    public void addActiveState(State state) {
        this.activeStates.add(state);
    }

    public void addActiveStates(SortedSet<State> states) {
        this.activeStates.addAll(states);
    }

    public void clearAndSetActiveStates(SortedSet<State> states) {
        this.activeStates.clear();
        this.addActiveStates(states);
    }

    public void removeActiveState(State state) {
        this.activeStates.remove(state);
    }

    public boolean isActiveStateByName(String stateName) {
        boolean result = false;
        State aux = null;
        Iterator activeIter = this.activeStates.iterator();
        while (!result && activeIter.hasNext()) {
            aux = (State)activeIter.next();
            result = aux.getName().equals(stateName);
        }
        return result;
    }

    public boolean isActiveState(State state) {
        return this.isActiveStateByName(state.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getDataFromURL(URL url) {
        String protocol = url.getProtocol();
        URLDataHandler dataHandler = this.dataHandlers.get(protocol);
        Object data = null;
        if (dataHandler == null) {
            try {
                Object aux = url.getContent();
                if (aux == null) return (T)data;
                data = aux;
                return (T)data;
            }
            catch (ClassCastException e) {
                throw new RuntimeException(String.format("The resource class is not compatible with expected, url: %s", url), e);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Custom protocol {0} not supported and the url {1} can't be loaded with error {2}", new Object[]{url.getProtocol(), url, e.getMessage()});
                this.logger.log(Level.SEVERE, "This could happen for two reasons, you are using a custom protocol and you haven't registered the URLDataHandler or you are using a default Java URL and there has been an IOException.");
                throw new RuntimeException("Custom protocol not supported and standard URL failed.", e);
            }
        } else {
            data = dataHandler.getData(url);
        }
        return (T)data;
    }

    public void updateData(String id, Object value) {
        this.validateBeanExistInContext(id);
        this.runtimeContext.set(id, value);
    }

    public void createVarIfDontExist(String name, Object value) {
        if (!this.runtimeContext.has(name)) {
            this.runtimeContext.set(name, value);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getParentSessionId() {
        return this.parentSessionId;
    }

    public StateMachineModel getModel() {
        return this.model;
    }

    public boolean hasInternalEvents() {
        return !this.internalEventQueue.isEmpty();
    }

    public Event pollInternalEvent() {
        return this.internalEventQueue.poll();
    }

    public void offerInternalEvent(Event event) {
        this.internalEventQueue.offer(event);
    }

    public State getState(String stateName) {
        return (State)this.states.get(stateName);
    }

    public void executeScript(String code) {
        Script script = this.jexl.createScript(code);
        script.execute((JexlContext)this.runtimeContext);
    }

    public void executeScript(URL codeUri) throws IOException {
        Script script = this.jexl.createScript(codeUri);
        script.execute((JexlContext)this.runtimeContext);
    }

    public void clearStatesToInvoke() {
        this.statesToInvoke.clear();
    }

    public void addStateToInvoke(State state) {
        this.statesToInvoke.add(state);
    }

    public void removeStateToInvoke(State state) {
        this.statesToInvoke.remove(state);
    }

    public SortedSet<State> getStatesToInvoke() {
        return new TreeSet<State>(this.statesToInvoke);
    }

    public String getSessionName() {
        return this.model.getName();
    }

    public IOProcessor searchIOProcessor(String name) {
        return this.engine.getIOProcessor(name);
    }

    public IOProcessor getScxmlIOProcessor() {
        return this.engine.getIOProcessor("scxml");
    }

    public Set<IOProcessor> getIOProcessors() {
        return this.engine.getIOProcessors();
    }

    public Set<InvokeHandler> getInvokeHandlers() {
        return this.engine.getInvokeHandlers();
    }

    public InvokeHandler getInvokeHandler(String type) {
        return this.engine.getInvokeHandler(type);
    }

    public void offerExternalEvent(String eventName) {
        BasicEvent event = new BasicEvent(eventName);
        this.externalEventQueue.offer(event);
    }

    public void offerExternalEvent(String eventName, Object data) {
        BasicEvent event = new BasicEvent(eventName, data);
        this.externalEventQueue.offer(event);
    }

    public void offerExternalEvent(Event event) {
        this.externalEventQueue.offer(event);
    }

    public Event pollExternalEvent() {
        return this.externalEventQueue.poll();
    }

    public void registerInvokeSessionId(String invokeSessionId) {
        this.activeInvokeSessions.add(invokeSessionId);
    }

    public void unRegisterInvokeSessionId(String invokeSessionId) {
        this.activeInvokeSessions.remove(invokeSessionId);
    }

    public boolean isInvokeSessionActive(String invokeSessionId) {
        return this.activeInvokeSessions.contains(invokeSessionId);
    }

    public boolean hasExternalEvents() {
        return !this.externalEventQueue.isEmpty();
    }

    public int hashCode() {
        int prime = 659;
        int result = 1;
        result = 659 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JexlFSMContext other = (JexlFSMContext)obj;
        return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
    }

    public boolean existsVarName(String id) {
        return this.runtimeContext.has(id);
    }

    public void updateDataIfExists(String id, Object value) {
        if (this.runtimeContext.has(id)) {
            this.updateData(id, value);
        }
    }

    public void saveCurrentConfiguration() {
        this.lastKnownConfiguration = new JexlMapFSMContextInstance(this.sessionId, this.parentSessionId, this.runtimeContext, this.activeStates);
    }

    public ContextInstance getLastStableConfiguration() {
        return this.lastKnownConfiguration;
    }
}

