/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.model.basic.state;

import com.nosolojava.fsm.impl.model.basic.datamodel.BasicDataModel;
import com.nosolojava.fsm.impl.model.basic.state.BasicInitialState;
import com.nosolojava.fsm.impl.model.basic.transition.BasicTransition;
import com.nosolojava.fsm.impl.runtime.basic.StateMachineUtils;
import com.nosolojava.fsm.model.config.exception.ConfigurationException;
import com.nosolojava.fsm.model.datamodel.Data;
import com.nosolojava.fsm.model.datamodel.DataModel;
import com.nosolojava.fsm.model.externalcomm.Invoke;
import com.nosolojava.fsm.model.state.DoneData;
import com.nosolojava.fsm.model.state.HistoryTypes;
import com.nosolojava.fsm.model.state.InitialState;
import com.nosolojava.fsm.model.state.State;
import com.nosolojava.fsm.model.transition.Transition;
import com.nosolojava.fsm.runtime.executable.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BasicState
implements State {
    private static final String INITIAL_STATE_ALREADY_SET_ERROR = "Initial state already set";
    private static final long serialVersionUID = 4170507445167998847L;
    private final String name;
    private final State parent;
    private final List<Transition> transitions = new ArrayList<Transition>();
    private final List<Executable> onEntryExecutables = new ArrayList<Executable>();
    private final List<Executable> onExitExecutables = new ArrayList<Executable>();
    private final List<Invoke> invokes = new ArrayList<Invoke>();
    private final DataModel dataModel = new BasicDataModel();
    private int documentOrder = -1;
    private InitialState initialState = null;
    private final boolean finalState;
    protected boolean historyState = false;
    private final List<State> childrens = new ArrayList<State>();
    protected final List<State> historyChildrens = new ArrayList<State>();
    private boolean parallel = false;
    private final DoneData doneData;
    public static final String ROOT_STATE_NAME = "scxml";
    private static final String ROOT_NAME_RESERVED_ERROR = "scxml is a reserved state name.";
    private static final String PARENT_CANT_BE_NULL_ERROR = "Parent can't be null";

    protected BasicState(String name, State parent, DoneData doneData, boolean finalState) throws ConfigurationException {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            if (parent.isHistoryState()) {
                throw new ConfigurationException("History states can't have children");
            }
            parent.getChildrens().add(this);
            this.recalculateDocumentOrderAndValidateNames();
        } else {
            this.documentOrder = 0;
        }
        this.doneData = doneData;
        this.finalState = finalState;
    }

    public static BasicState createRootState() throws ConfigurationException {
        return new BasicState(ROOT_STATE_NAME, null, null, false);
    }

    public static BasicState createBasicState(String name, State parent) throws ConfigurationException {
        if (parent == null) {
            throw new ConfigurationException(PARENT_CANT_BE_NULL_ERROR);
        }
        if (ROOT_STATE_NAME.equals(name)) {
            throw new ConfigurationException(ROOT_NAME_RESERVED_ERROR);
        }
        return new BasicState(name, parent, null, false);
    }

    public static BasicState createFinalState(String name, State parent, DoneData donedata) throws ConfigurationException {
        if (parent == null) {
            throw new ConfigurationException(PARENT_CANT_BE_NULL_ERROR);
        }
        if (ROOT_STATE_NAME.equals(name)) {
            throw new ConfigurationException(ROOT_NAME_RESERVED_ERROR);
        }
        return new BasicState(name, parent, donedata, true);
    }

    public static BasicState createParallelState(String name, State parent) throws ConfigurationException {
        BasicState state = BasicState.createBasicState(name, parent);
        state.setParallel(true);
        return state;
    }

    public boolean isRootState() {
        return ROOT_STATE_NAME.equals(this.name);
    }

    private void recalculateDocumentOrderAndValidateNames() {
        this.documentOrder = this.calculateDocumentOrder(this.parent);
        this.updateRightSiblingsOrder(this.parent, this.documentOrder);
    }

    private int calculateDocumentOrder(State parent) {
        int result;
        if (parent.hasChildrens() && parent.getChildrens().size() > 1) {
            int bigBrotherIndex = parent.getChildrens().size() - 2;
            State bigBrother = (State)parent.getChildrens().get(bigBrotherIndex);
            State bigBrotherLastChildren = this.getLastChildren(bigBrother);
            result = bigBrotherLastChildren.getDocumentOrder() + 1;
        } else {
            result = parent.getDocumentOrder() + 1;
        }
        return result;
    }

    private State getLastChildren(State state) {
        State lastChildren;
        if (state.hasChildrens()) {
            State aux = (State)state.getChildrens().get(state.getChildrens().size() - 1);
            lastChildren = this.getLastChildren(aux);
        } else {
            lastChildren = state;
        }
        return lastChildren;
    }

    public Transition addTransition(String event, String targetState) {
        BasicTransition transition = new BasicTransition(this.name, event, targetState);
        this.addTransition(transition);
        return transition;
    }

    public Transition addTransition(State source, String event, String targetState) {
        BasicTransition transition = new BasicTransition(source.getName(), event, targetState);
        this.addTransition(transition);
        return transition;
    }

    public Transition addTransition(State source, String event, String targetState, String guardCondition) {
        BasicTransition transition = new BasicTransition(source.getName(), event, targetState, guardCondition);
        this.addTransition(transition);
        return transition;
    }

    public Transition addTransition(String event, String targetState, String guarCondition) {
        BasicTransition transition = new BasicTransition(this.name, event, targetState, guarCondition);
        this.addTransition(transition);
        return transition;
    }

    public Transition addInternalTransition(String event, String targetState) {
        BasicTransition transition = new BasicTransition(this.name, event, targetState, null, true);
        this.addTransition(transition);
        return transition;
    }

    public Transition addInternalTransition(String event, String targetState, String guarCondition) {
        BasicTransition transition = new BasicTransition(this.name, event, targetState, guarCondition, true);
        this.addTransition(transition);
        return transition;
    }

    public Transition addInternalTransition(State source, String event, String targetState) {
        BasicTransition transition = new BasicTransition(source.getName(), event, targetState, null, true);
        this.addTransition(transition);
        return transition;
    }

    public Transition addInternalTransition(State source, String event, String targetState, String guarCondition) {
        BasicTransition transition = new BasicTransition(source.getName(), event, targetState, guarCondition, true);
        this.addTransition(transition);
        return transition;
    }

    private void updateRightSiblingsOrder(State parent, int lastDocumentOrder) {
        State grandParent = parent.getParent();
        if (grandParent != null) {
            for (State aunt : grandParent.getChildrens()) {
                if (aunt.getDocumentOrder() <= parent.getDocumentOrder()) continue;
                lastDocumentOrder = this.updateAuntDocumentOrder(aunt, lastDocumentOrder);
            }
            this.updateRightSiblingsOrder(grandParent, lastDocumentOrder);
        }
    }

    private int updateAuntDocumentOrder(State aunt, int lastDocumentOrder) {
        aunt.setDocumentOrder(++lastDocumentOrder);
        for (State cousin : aunt.getChildrens()) {
            lastDocumentOrder = this.updateAuntDocumentOrder(cousin, lastDocumentOrder);
        }
        return lastDocumentOrder;
    }

    public int compareTo(State right) {
        return StateMachineUtils.entryOrderComparator.compare((Object)this, (Object)right);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicState other = (BasicState)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }

    public boolean isDescendant(State otherState) {
        boolean result = false;
        for (State aux = this.getParent(); !result && aux != null; aux = aux.getParent()) {
            result = aux.equals(otherState);
        }
        return result;
    }

    protected void calculateBreadCrumb(List<State> breadcrumb) {
        BasicState aux = (BasicState)this.parent;
        if (aux != null) {
            aux.calculateBreadCrumb(breadcrumb);
            breadcrumb.add(aux);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    public List<Executable> getOnEntryExecutables() {
        return this.onEntryExecutables;
    }

    public void addOnEntryExecutable(Executable varName) {
        this.onEntryExecutables.add(varName);
    }

    public void addOnEntryExecutables(List<Executable> varNames) {
        this.onEntryExecutables.addAll(varNames);
    }

    public void clearAndSetOnEntryExecutables(List<Executable> varNames) {
        this.onEntryExecutables.clear();
        this.addOnEntryExecutables(varNames);
    }

    public List<Executable> getOnExitExecutables() {
        return this.onExitExecutables;
    }

    public void addOnExitExecutable(Executable executable) {
        this.onExitExecutables.add(executable);
    }

    public void addOnExitExecutables(List<Executable> executables) {
        this.onExitExecutables.addAll(executables);
    }

    public void clearAndSetOnExitExecutables(List<Executable> executables) {
        this.onExitExecutables.clear();
        this.addOnExitExecutables(executables);
    }

    public List<Invoke> getInvokes() {
        return this.invokes;
    }

    public void addInvoke(Invoke invoke) {
        this.invokes.add(invoke);
    }

    public void addInvokes(List<Invoke> invokes) {
        this.invokes.addAll(invokes);
    }

    public void clearAndSetInvokes(List<Invoke> invokes) {
        this.invokes.clear();
        this.addInvokes(invokes);
    }

    public void addData(Data data) {
        this.dataModel.addData(data);
    }

    public void addData(List<Data> dataList) {
        this.dataModel.addDataList(dataList);
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public State getParent() {
        return this.parent;
    }

    public List<State> getBreadCrumb() {
        ArrayList<State> breadcrumb = new ArrayList<State>();
        this.calculateBreadCrumb(breadcrumb);
        return breadcrumb;
    }

    public int getDocumentOrder() {
        return this.documentOrder;
    }

    public void setDocumentOrder(int documentOrder) {
        this.documentOrder = documentOrder;
    }

    public boolean hasChildrens() {
        return this.childrens.size() > 0;
    }

    public List<State> getChildrens() {
        return this.childrens;
    }

    public List<State> getHistoryStates() {
        return this.historyChildrens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitialState getInitialState() {
        if (this.initialState == null) {
            BasicState basicState = this;
            synchronized (basicState) {
                if (this.initialState == null) {
                    State firstChildren = this.getChildrens().get(0);
                    this.createInitialFromName(firstChildren.getName());
                }
            }
        }
        return this.initialState;
    }

    private void createInitialFromName(String initialName) {
        String uid = UUID.randomUUID().toString();
        this.initialState = new BasicInitialState(uid, this.name, initialName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialState(InitialState initialState) throws ConfigurationException {
        BasicState basicState = this;
        synchronized (basicState) {
            if (this.initialState != null) {
                throw new ConfigurationException(INITIAL_STATE_ALREADY_SET_ERROR);
            }
            this.initialState = initialState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialStateName(String initialStateName) throws ConfigurationException {
        BasicState basicState = this;
        synchronized (basicState) {
            if (this.initialState != null) {
                throw new ConfigurationException(INITIAL_STATE_ALREADY_SET_ERROR);
            }
            this.createInitialFromName(initialStateName);
        }
    }

    public boolean isHistoryState() {
        return this.historyState;
    }

    public HistoryTypes getHistoryType() {
        return null;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public DoneData getDoneData() {
        return this.doneData;
    }

    public boolean isFinal() {
        return this.finalState;
    }

    public static void main(String[] args) throws ConfigurationException {
        BasicState s = BasicState.createBasicState("s", BasicState.createRootState());
        s.setInitialStateName("s1");
        BasicState s1 = BasicState.createBasicState("s1", s);
        BasicState s11 = BasicState.createBasicState("s11", s1);
        s1.setInitialStateName("s11");
        BasicState s2 = BasicState.createBasicState("s2", s);
        BasicState s21 = BasicState.createBasicState("s21", s2);
        s2.setInitialStateName("s21");
        List<State> breadcrumb = s11.getBreadCrumb();
        for (State state : breadcrumb) {
            System.out.print(state.getName() + ".");
        }
        System.out.println();
        breadcrumb = s21.getBreadCrumb();
        for (State state : breadcrumb) {
            System.out.print(state.getName() + ".");
        }
    }
}

