/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.executable.basic;

import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.executable.Executable;
import com.nosolojava.fsm.runtime.executable.ForEach;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BasicForEach
implements ForEach {
    private static final long serialVersionUID = -2108800262588663830L;
    protected final List<Executable> executables = new ArrayList<Executable>();
    private final String arrayName;
    private final String itemName;
    private final String indexName;

    public BasicForEach(String array, String item, String index, List<Executable> executables) {
        this.arrayName = array;
        this.itemName = item;
        this.indexName = index;
        this.executables.addAll(executables);
    }

    public BasicForEach(String array, String item, List<Executable> executables) {
        this.arrayName = array;
        this.itemName = item;
        this.indexName = null;
        this.executables.addAll(executables);
    }

    public void run(Context context) {
        block4: {
            Class<?> arrayClass;
            Serializable arrayObj;
            block3: {
                arrayObj = (Serializable)context.getDataByName(this.arrayName);
                context.createVarIfDontExist(this.itemName, null);
                if (this.indexName != null && !"".equals(this.indexName)) {
                    context.createVarIfDontExist(this.indexName, null);
                }
                if (!(arrayClass = arrayObj.getClass()).isArray()) break block3;
                int arrayLength = Array.getLength(arrayObj);
                for (int i = 0; i < arrayLength; ++i) {
                    Object arrayItem = Array.get(arrayObj, i);
                    this.processItem(i, context, arrayItem);
                }
                break block4;
            }
            if (!Collection.class.isAssignableFrom(arrayClass)) break block4;
            List arrayList = (List)((Object)arrayObj);
            int i = 0;
            for (Object arrayItem : arrayList) {
                this.processItem(i, context, arrayItem);
                ++i;
            }
        }
    }

    private void processItem(int index, Context context, Object arrayItem) {
        if (this.indexName != null && !"".equals(this.indexName)) {
            context.updateData(this.indexName, (Object)index);
        }
        context.updateData(this.itemName, arrayItem);
        this.executeAll(context);
    }

    private void executeAll(Context context) {
        for (Executable exec : this.executables) {
            exec.run(context);
        }
    }
}

