/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.executable.basic;

import com.nosolojava.fsm.impl.runtime.executable.basic.BasicConditional;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.executable.Elif;
import com.nosolojava.fsm.runtime.executable.Else;
import com.nosolojava.fsm.runtime.executable.Executable;
import com.nosolojava.fsm.runtime.executable.If;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BasicIf
extends BasicConditional
implements If {
    private static final long serialVersionUID = -415238773021486012L;
    private final List<Elif> elifs = new ArrayList<Elif>();
    private final Else elseOperation;

    public BasicIf(String condition) {
        this(condition, null, null, null);
    }

    public BasicIf(String condition, List<Executable> executables) {
        this(condition, null, null, executables);
    }

    public BasicIf(String condition, Else elseOperation, List<Executable> executables) {
        this(condition, null, elseOperation, executables);
    }

    public BasicIf(String condition, List<Elif> elifs, Else elseOperation, List<Executable> executables) {
        super(condition, executables);
        if (elifs != null) {
            this.elifs.addAll(elifs);
        }
        this.elseOperation = elseOperation;
    }

    @Override
    public boolean runIf(Context context) {
        boolean result = false;
        if (super.runIf(context)) {
            result = true;
        } else {
            boolean enterElif = false;
            Iterator<Elif> iterElif = this.elifs.iterator();
            while (!enterElif && iterElif.hasNext()) {
                Elif elif = iterElif.next();
                enterElif = elif.runIf(context);
            }
            if (!enterElif && this.elseOperation != null) {
                this.elseOperation.run(context);
            }
        }
        return result;
    }

    public List<Elif> getElifs() {
        return this.elifs;
    }

    public void addElif(Elif elif) {
        this.elifs.add(elif);
    }

    public void addElifs(List<Elif> elifs) {
        this.elifs.addAll(elifs);
    }

    public void clearAndSetElifs(List<Elif> elifs) {
        this.elifs.clear();
        this.addElifs(elifs);
    }
}

