/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic;

import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.executable.externalcomm.InvokeHandler;
import com.nosolojava.fsm.runtime.executable.externalcomm.InvokeInfo;
import com.nosolojava.fsm.runtime.executable.externalcomm.Message;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBasicInvokeHandler
implements InvokeHandler {
    private static final long serialVersionUID = -7602242020573620626L;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected ConcurrentHashMap<String, Context> invokeIdContextMap = new ConcurrentHashMap();

    public abstract String getType();

    public abstract void invokeServiceInternal(InvokeInfo var1, Context var2);

    public abstract void sendMessageToService(Message var1, Context var2);

    public abstract void onEndSession(String var1, Context var2);

    public void invokeService(InvokeInfo input, Context context) {
        String invokeId = input.getInvokeId();
        this.invokeIdContextMap.put(invokeId, context);
        this.invokeServiceInternal(input, context);
    }

    public void sendMessageToService(Message message) {
        String invokeId = message.getId();
        if (this.invokeIdContextMap.containsKey(invokeId)) {
            Context context = this.getContextByInvokeId(invokeId);
            this.sendMessageToService(message, context);
        } else {
            this.logger.log(Level.SEVERE, "Error finding invoke session for event. InvokeId: {0}", new Object[]{invokeId});
        }
    }

    public void endSession(String invokeId) {
        if (this.invokeIdContextMap.containsKey(invokeId)) {
            Context context = this.invokeIdContextMap.get(invokeId);
            this.onEndSession(invokeId, context);
            this.invokeIdContextMap.remove(invokeId);
        }
    }

    public Context getContextByInvokeId(String invokeId) {
        return this.invokeIdContextMap.get(invokeId);
    }
}

