/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.spring;

import com.objectsql.BaseService;
import com.objectsql.BaseServiceImpl;
import com.objectsql.ObjectSQLManager;
import com.objectsql.listener.ChangeListener;
import com.objectsql.listener.ChangedListener;
import com.objectsql.listener.DefaultListener;
import com.objectsql.listener.QueryListener;
import com.objectsql.utils.ORMUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;

public class SpringBaseServiceImpl<T>
extends BaseServiceImpl<T>
implements BeanFactoryAware,
SmartInitializingSingleton {
    private ListableBeanFactory factory;

    public SpringBaseServiceImpl() {
    }

    public SpringBaseServiceImpl(ObjectSQLManager objectSQLManager) {
        super(objectSQLManager);
    }

    public SpringBaseServiceImpl(DataSource dataSource) {
        super(dataSource);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ListableBeanFactory) {
            this.factory = (ListableBeanFactory)beanFactory;
        }
    }

    private <S> List<S> sortListeners(ListableBeanFactory beanFactory, Class<S> clazz) {
        ArrayList result = new ArrayList();
        Map listenerMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, clazz);
        for (Object listener : listenerMap.values()) {
            if (BaseService.class.isAssignableFrom(listener.getClass()) || !ORMUtils.isTheSameClass(this.getBaseClass(), listener.getClass())) continue;
            result.add(listener);
        }
        return result;
    }

    public void afterSingletonsInstantiated() {
        List<DefaultListener> defaultListenerList = this.sortListeners(this.factory, DefaultListener.class);
        this.setDefaultListeners(defaultListenerList);
        List<ChangeListener> changeListenerList = this.sortListeners(this.factory, ChangeListener.class);
        this.setChangeListeners(changeListenerList);
        List<ChangedListener> changedListenerList = this.sortListeners(this.factory, ChangedListener.class);
        this.setChangedListeners(changedListenerList);
        List<QueryListener> queryListenerList = this.sortListeners(this.factory, QueryListener.class);
        this.setQueryListeners(queryListenerList);
    }
}

