/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax;

import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.AnalysisResult;
import com.scriptbasic.interfaces.Analyzer;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.GenericList;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.ListAnalyzer;
import com.scriptbasic.utility.FactoryUtility;
import com.scriptbasic.utility.LexUtility;

public abstract class AbstractGenericListAnalyzer<T extends GenericList<Z>, K extends T, Z extends AnalysisResult, A extends Analyzer<Z>>
implements ListAnalyzer<T> {
    public abstract Factory getFactory();

    protected T analyze(K list, A analyzer) throws AnalysisException {
        list.add(analyzer.analyze());
        LexicalElement lexicalElement = LexUtility.peek(FactoryUtility.getLexicalAnalyzer(this.getFactory()));
        while (AbstractGenericListAnalyzer.isComma(lexicalElement)) {
            LexUtility.get(FactoryUtility.getLexicalAnalyzer(this.getFactory()));
            list.add(analyzer.analyze());
            lexicalElement = LexUtility.peek(FactoryUtility.getLexicalAnalyzer(this.getFactory()));
        }
        return (T)list;
    }

    private static boolean isComma(LexicalElement lexicalElement) {
        return lexicalElement != null && lexicalElement.isSymbol(",") != false;
    }
}

