/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.executors.commands.CommandUse;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.KlassUtility;
import com.scriptbasic.utility.LexUtility;

public class CommandAnalyzerUse
extends AbstractCommandAnalyzer {
    @Override
    public Command analyze() throws AnalysisException {
        String className = ExpressionUtility.convertToString(this.analyzeExpression());
        LexUtility.checkLexeme(this.getFactory(), "from", "Keyword 'FROM' is missing in command 'USE'");
        String packageName = ExpressionUtility.convertToString(this.analyzeExpression());
        String aliasName = null;
        aliasName = LexUtility.isLexeme(this.getFactory(), "as") ? ExpressionUtility.convertToString(this.analyzeExpression()) : className;
        this.consumeEndOfLine();
        if (className.indexOf(46) != -1 || aliasName.indexOf(46) != -1) {
            throw new GenericSyntaxException("class name and alias name should not contain dot in command USE");
        }
        String fullClassName = packageName + "." + className;
        Class<?> klass = null;
        try {
            klass = KlassUtility.forNameEx(fullClassName);
        }
        catch (GenericSyntaxException e) {
            throw new GenericSyntaxException("The class in the USE statement is not found.", e);
        }
        CommandUse node = new CommandUse();
        node.setKlass(klass);
        node.setAlias(aliasName);
        return node;
    }

    @Override
    protected String getName() {
        return "USE";
    }
}

