/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.api.script;

import com.scriptbasic.api.script.ScriptBasicEngineFactory;
import com.scriptbasic.factories.Context;
import com.scriptbasic.factories.ContextBuilder;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import java.io.Reader;
import java.io.StringReader;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class ScriptEngine
extends AbstractScriptEngine {
    public final ScriptBasicEngineFactory scriptEngineFactory;
    public Context ctx = ContextBuilder.newContext();

    public ScriptEngine(ScriptBasicEngineFactory scriptEngineFactory) {
        this.ctx.configuration = scriptEngineFactory.config;
        this.scriptEngineFactory = scriptEngineFactory;
    }

    private static void unmergeBindings(ExtendedInterpreter interpreter, Bindings bindings) throws ExecutionException {
        for (String name : bindings.keySet()) {
            bindings.put(name, interpreter.getVariable(name));
        }
    }

    private static void mergeBinding(ExtendedInterpreter interpreter, Bindings bindings) throws ExecutionException {
        for (String name : bindings.keySet()) {
            interpreter.setVariable(name, bindings.get(name));
        }
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try {
            this.ctx = ContextBuilder.from(this.ctx, reader, context.getReader(), context.getWriter(), context.getErrorWriter());
            ScriptEngine.mergeBinding(this.ctx.interpreter, context.getBindings(200));
            ScriptEngine.mergeBinding(this.ctx.interpreter, context.getBindings(100));
            this.ctx.interpreter.setProgram(this.ctx.syntaxAnalyzer.analyze());
            this.ctx.interpreter.execute();
            ScriptEngine.unmergeBindings(this.ctx.interpreter, context.getBindings(100));
            ScriptEngine.unmergeBindings(this.ctx.interpreter, context.getBindings(200));
        }
        catch (AnalysisException | ExecutionException e) {
            throw new ScriptException(e);
        }
        return null;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptBasicEngineFactory getFactory() {
        return this.scriptEngineFactory;
    }
}

