/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.leftvalue;

import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.executors.leftvalues.ArrayElementAccessLeftValueModifier;
import com.scriptbasic.executors.leftvalues.BasicLeftValue;
import com.scriptbasic.executors.leftvalues.LeftValueModifier;
import com.scriptbasic.executors.leftvalues.ObjectFieldAccessLeftValueModifier;
import com.scriptbasic.factories.Context;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.interfaces.LeftValue;
import com.scriptbasic.interfaces.LeftValueAnalyzer;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;

public abstract class AbstractLeftValueAnalyzer
implements LeftValueAnalyzer {
    protected final Context ctx;

    protected AbstractLeftValueAnalyzer(Context ctx) {
        this.ctx = ctx;
    }

    private static LeftValueModifier analyzeFieldAccess(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        lexicalAnalyzer.get();
        ObjectFieldAccessLeftValueModifier lvm = new ObjectFieldAccessLeftValueModifier();
        LexicalElement lexicalElement = lexicalAnalyzer.peek();
        if (lexicalElement != null && lexicalElement.isIdentifier().booleanValue()) {
            lexicalAnalyzer.get();
            lvm.setFieldName(lexicalElement.getLexeme());
            return lvm;
        }
        throw new BasicSyntaxException("Left value . is not followed by a field name", lexicalElement, null);
    }

    private static boolean isModifierStart(LexicalElement lexicalElement) {
        return lexicalElement != null && (lexicalElement.isSymbol(".") != false || lexicalElement.isSymbol("[") != false);
    }

    private static boolean isArrayAccessStart(LexicalElement lexicalElement) {
        return lexicalElement != null && lexicalElement.isSymbol("[") != false;
    }

    private static boolean isFieldAccessStart(LexicalElement lexicalElement) {
        return lexicalElement != null && lexicalElement.isSymbol(".") != false;
    }

    private LeftValueModifier analyzeArrayAccess(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        lexicalAnalyzer.get();
        ArrayElementAccessLeftValueModifier lvm = new ArrayElementAccessLeftValueModifier();
        ExpressionList indexList = (ExpressionList)this.ctx.expressionListAnalyzer.analyze();
        lvm.setIndexList(indexList);
        LexicalElement lexicalElement = lexicalAnalyzer.peek();
        if (lexicalElement != null && lexicalElement.isSymbol("]").booleanValue()) {
            lexicalAnalyzer.get();
            return lvm;
        }
        throw new BasicSyntaxException("Left value array access does not have ]", lexicalElement, null);
    }

    @Override
    public LeftValue analyze() throws AnalysisException {
        BasicLeftValue leftValue;
        LexicalElement lexicalElement = this.ctx.lexicalAnalyzer.peek();
        if (lexicalElement != null && lexicalElement.isIdentifier().booleanValue()) {
            this.ctx.lexicalAnalyzer.get();
            leftValue = new BasicLeftValue();
            leftValue.setIdentifier(lexicalElement.getLexeme());
            lexicalElement = this.ctx.lexicalAnalyzer.peek();
            while (AbstractLeftValueAnalyzer.isModifierStart(lexicalElement)) {
                LeftValueModifier modifier;
                if (AbstractLeftValueAnalyzer.isArrayAccessStart(lexicalElement)) {
                    modifier = this.analyzeArrayAccess(this.ctx.lexicalAnalyzer);
                } else if (AbstractLeftValueAnalyzer.isFieldAccessStart(lexicalElement)) {
                    modifier = AbstractLeftValueAnalyzer.analyzeFieldAccess(this.ctx.lexicalAnalyzer);
                } else {
                    throw new BasicInterpreterInternalError("left value parsing internal error, there is a modifier with unknown type");
                }
                leftValue.addModifier(modifier);
                lexicalElement = this.ctx.lexicalAnalyzer.peek();
            }
        } else {
            throw new BasicSyntaxException("left value should start with an identifier", lexicalElement, null);
        }
        return leftValue;
    }
}

