/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.executors.leftvalues.BasicLeftValue;
import com.scriptbasic.executors.operators.JavaObjectFieldAccessOperator;
import com.scriptbasic.executors.rightvalues.BasicStringValue;
import com.scriptbasic.executors.rightvalues.VariableAccess;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.LeftValue;
import com.scriptbasic.interfaces.LeftValueList;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.utility.CastUtility;
import com.scriptbasic.utility.NoInstance;
import com.scriptbasic.utility.RightValueUtility;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ExpressionUtility {
    private ExpressionUtility() {
        NoInstance.isPossible();
    }

    private static boolean parameterLengthMatch(Class<?>[] parameterTypes, List<RightValue> args) {
        if (args == null) {
            return true;
        }
        return parameterTypes.length >= args.size();
    }

    public static RightValue callBasicFunction(ExtendedInterpreter interpreter, RightValue[] argumentValues, CommandSub commandSub, String functionName) throws ExecutionException {
        RightValue result = null;
        interpreter.push();
        LeftValueList arguments = commandSub.getArguments();
        ExpressionUtility.registerLocalVariablesWithValues(arguments, argumentValues, interpreter);
        interpreter.disableHook();
        interpreter.setReturnValue(null);
        interpreter.enableHook();
        interpreter.getHook().beforeSubroutineCall(functionName, arguments, argumentValues);
        interpreter.execute(commandSub.getNextCommand());
        result = interpreter.getReturnValue();
        interpreter.pop();
        return result;
    }

    private static void registerLocalVariablesWithValues(LeftValueList arguments, RightValue[] argumentValues, ExtendedInterpreter interpreter) throws ExecutionException {
        if (arguments != null) {
            Iterator argumentIterator = arguments.iterator();
            for (RightValue argumentValue : argumentValues) {
                LeftValue argument;
                if (argumentIterator.hasNext()) {
                    argument = (LeftValue)argumentIterator.next();
                    if (!(argument instanceof BasicLeftValue)) {
                        throw new BasicRuntimeException("subroutine formal argument list is too long");
                    }
                } else {
                    throw new BasicRuntimeException("subroutine formal argument is erroneous");
                }
                String name = ((BasicLeftValue)argument).getIdentifier();
                interpreter.getVariables().registerLocalVariable(name);
                interpreter.setVariable(name, argumentValue);
            }
        }
    }

    public static Object[] getObjectArray(List<RightValue> args, Method method, ExtendedInterpreter extendedInterpreter) throws ExecutionException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (!ExpressionUtility.parameterLengthMatch(parameterTypes, args)) {
            throw new BasicRuntimeException("Different number of parameters calling the Java method '" + method.getName() + "'");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int parameterIndex = 0;
        if (args != null) {
            for (RightValue arg : args) {
                Object object = CastUtility.cast(RightValueUtility.getValueObject(arg), parameterTypes[parameterIndex]);
                result.add(object);
                ++parameterIndex;
            }
        }
        while (parameterIndex < parameterTypes.length) {
            result.add(null);
            ++parameterIndex;
        }
        return result.isEmpty() ? null : result.toArray(new Object[0]);
    }

    public static List<RightValue> evaluateExpressionList(ExtendedInterpreter extendedInterpreter, ExpressionList expressionList) throws ExecutionException {
        LinkedList<RightValue> args = null;
        if (expressionList != null) {
            args = new LinkedList<RightValue>();
            for (Expression expression : expressionList) {
                args.add(expression.evaluate(extendedInterpreter));
            }
        }
        return args;
    }

    public static String convertToString(Expression expression) throws AnalysisException {
        if (expression instanceof VariableAccess) {
            return ((VariableAccess)expression).getVariableName();
        }
        if (expression instanceof JavaObjectFieldAccessOperator) {
            JavaObjectFieldAccessOperator ofao = (JavaObjectFieldAccessOperator)expression;
            return ExpressionUtility.convertToString(ofao.getLeftOperand()) + "." + ExpressionUtility.convertToString(ofao.getRightOperand());
        }
        if (expression instanceof BasicStringValue) {
            return (String)((BasicStringValue)expression).getValue();
        }
        throw new BasicSyntaxException("class, package or symbol name are not vaid in command USE");
    }
}

