/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.context.Context;
import com.scriptbasic.executors.GenericExpressionList;
import com.scriptbasic.executors.commands.CommandCall;
import com.scriptbasic.executors.rightvalues.FunctionCall;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.spi.Command;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;
import java.util.LinkedList;
import java.util.List;

public class CommandAnalyzerDSL
extends AbstractCommandAnalyzer {
    private final List<DslLine> dslLines = new LinkedList<DslLine>();

    protected CommandAnalyzerDSL(Context ctx) {
        super(ctx);
    }

    @Override
    public Command analyze() throws AnalysisException {
        this.ctx.lexicalAnalyzer.resetLine();
        LexicalElement lexeme = this.ctx.lexicalAnalyzer.get();
        if (lexeme != null && lexeme.isSymbol("sentence").booleanValue()) {
            this.defineDSLRule();
            return null;
        }
        for (DslLine line : this.dslLines) {
            this.ctx.lexicalAnalyzer.resetLine();
            Command command = this.analyzeWith(line);
            if (command == null) continue;
            return command;
        }
        throw new BasicSyntaxException("Can not analyze the line as DSL.");
    }

    private Command analyzeWith(DslLine line) {
        GenericExpressionList expressionList = new GenericExpressionList();
        for (String match : line.syntaxElements) {
            LexicalElement lexicalElement;
            if (match.equalsIgnoreCase("$expression")) {
                Expression expression;
                try {
                    expression = this.analyzeExpression();
                }
                catch (AnalysisException ignored) {
                    return null;
                }
                expressionList.add(expression);
                continue;
            }
            try {
                lexicalElement = this.ctx.lexicalAnalyzer.get();
            }
            catch (AnalysisException ignored) {
                return null;
            }
            if (lexicalElement.getLexeme().equalsIgnoreCase(match)) continue;
            return null;
        }
        FunctionCall functionCall = new FunctionCall();
        functionCall.setVariableName(line.methodName);
        functionCall.setExpressionList(expressionList);
        return new CommandCall(functionCall);
    }

    private void defineDSLRule() throws AnalysisException {
        LexicalElement actualSentence = this.ctx.lexicalAnalyzer.get();
        if (!actualSentence.isString().booleanValue()) {
            throw new BasicSyntaxException("There should be a string after the keyword 'sentence'");
        }
        String sentence = actualSentence.stringValue();
        LexicalElement callsKW = this.ctx.lexicalAnalyzer.get();
        if (!callsKW.isSymbol("call").booleanValue()) {
            throw new BasicSyntaxException("missing keyword 'call' after string in command 'sentence'");
        }
        LexicalElement functionNameLexicalElement = this.ctx.lexicalAnalyzer.get();
        if (!functionNameLexicalElement.isIdentifier().booleanValue()) {
            throw new BasicSyntaxException("there should be a function name after the keyword 'call' defining a sentence\u00f3");
        }
        this.consumeEndOfLine();
        String[] syntaxElements = sentence.split("\\s+");
        if (syntaxElements.length == 0) {
            throw new BasicSyntaxException("sentence can not be empty");
        }
        String startElement = syntaxElements[0];
        if (startElement.equals("'") || startElement.equalsIgnoreCase("rem")) {
            throw new BasicSyntaxException("sentence should not look like as a comment");
        }
        this.dslLines.add(new DslLine(functionNameLexicalElement.getLexeme(), syntaxElements));
    }

    private class DslLine {
        final String methodName;
        final String[] syntaxElements;

        private DslLine(String methodName, String[] syntaxElements) {
            this.methodName = methodName;
            this.syntaxElements = syntaxElements;
        }
    }
}

