/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.actions;

import com.securenative.Logger;
import com.securenative.actions.Action;
import com.securenative.processors.BlacklistIp;
import com.securenative.processors.DeleteBlacklistedIp;
import com.securenative.processors.WhitelistIp;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionManager {
    private static Map<String, Class<?>[]> actionProcessors = new HashMap<String, Class<?>[]>();

    public ActionManager() {
        actionProcessors.put("block_ip", new Class[]{BlacklistIp.class});
        actionProcessors.put("unblock_ip", new Class[]{DeleteBlacklistedIp.class});
        actionProcessors.put("allow_ip", new Class[]{WhitelistIp.class});
    }

    public static void enforceActions(List<Action> actions) {
        actions.forEach(action -> {
            if (actionProcessors.get(action.getName()) != null) {
                Class<?>[] processors;
                for (Class<?> processor : processors = actionProcessors.get(action.getName())) {
                    try {
                        Class<?> pros = Class.forName(processor.getName());
                        Constructor<?> ctor = pros.getConstructor(new Class[0]);
                        ctor.newInstance(new Object[0]);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        Logger.getLogger().debug(String.format("Could not initialize processor %s; %s", processor.getName(), e));
                    }
                }
            }
        });
    }
}

