/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.configurations;

import com.securenative.Logger;
import com.securenative.events.Event;
import com.securenative.events.EventManager;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConfigurationUpdaterRunnable
implements Runnable {
    private EventManager eventManager;
    private String requestUrl;
    private Event event;
    private Thread worker;
    private AtomicBoolean running = new AtomicBoolean(false);
    private long interval;

    public ConfigurationUpdaterRunnable(EventManager eventManager, String requestUrl, Event event, long interval) {
        this.eventManager = eventManager;
        this.requestUrl = requestUrl;
        this.event = event;
        this.interval = interval;
    }

    @Override
    public void run() {
        Logger.getLogger().debug("ConfigurationUpdate");
        this.running.set(true);
        while (this.running.get()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Logger.getLogger().debug("Thread was interrupted, Closing configuration updater");
            }
        }
    }

    public void interrupt() {
        this.running.set(false);
        this.worker.interrupt();
    }

    public boolean isRunning() {
        return this.running.get();
    }
}

