/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.securenative.Logger;
import com.securenative.configurations.SecureNativeOptions;
import com.securenative.events.Event;
import com.securenative.events.EventManager;
import com.securenative.exceptions.SecureNativeSDKException;
import com.securenative.models.Message;
import com.securenative.models.RiskLevel;
import com.securenative.models.RiskResult;
import com.securenative.utils.Utils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;

public class SnEventManager
implements EventManager {
    private final String USER_AGENT_VALUE = "com.securenative.snlogic.SecureNative-java";
    private final String SN_VERSION = "SN-Version";
    private BoundRequestBuilder asyncClient;
    private String apiKey;
    private Utils utils;
    private ExecutorService executor;
    private ConcurrentLinkedQueue<Message> events;
    private ObjectMapper mapper;
    private int HTTP_STATUS_OK = 201;
    private String AUTHORIZATION = "Authorization";
    private SecureNativeOptions options;
    RiskResult defaultRiskResult = new RiskResult(RiskLevel.low.name(), 0.0, new String[0]);

    public SnEventManager(String apiKey, SecureNativeOptions options) throws SecureNativeSDKException {
        this.utils = new Utils();
        this.options = options;
        this.events = new ConcurrentLinkedQueue();
        if (Utils.isNullOrEmpty(apiKey) || options == null) {
            throw new SecureNativeSDKException("You must pass a valid api key");
        }
        this.asyncClient = this.initializeAsyncHttpClient(options);
        this.apiKey = apiKey;
        if (this.options.getSdkEnabled() != null && !this.options.getSdkEnabled().booleanValue()) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
            Logger.getLogger().info("Starting thread listening to messages queue");
            this.executor.execute(() -> {
                try {
                    Thread.sleep((long)(Math.random() * 1000.0));
                    Message msg = this.events.poll();
                    if (msg != null) {
                        this.sendSync(msg.getSnEvent(), msg.getUrl());
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public RiskResult sendSync(Event event, String url) {
        if (this.options.getSdkEnabled() != null && !this.options.getSdkEnabled().booleanValue()) {
            return this.defaultRiskResult;
        }
        ((BoundRequestBuilder)this.asyncClient.setHeader((CharSequence)this.AUTHORIZATION, this.apiKey)).setUrl(url);
        try {
            this.asyncClient.setBody(this.mapper.writeValueAsString((Object)event));
            Response response = (Response)this.asyncClient.execute().get();
            if (response == null || response.getStatusCode() > this.HTTP_STATUS_OK) {
                Logger.getLogger().info(String.format("Secure Native http call failed to end point: %s  with event type %s. adding back to queue.", url, event.getEventType()));
                this.events.add(new Message(event, response.getUri().toUrl()));
            }
            String responseBody = response.getResponseBody();
            if (Utils.isNullOrEmpty(responseBody)) {
                Logger.getLogger().info(String.format("Secure Native http call to %s returned with empty response. returning default risk result.", url));
                return this.defaultRiskResult;
            }
            Logger.getLogger().info(String.format("Secure Native http call to %s was successful.", url));
            return (RiskResult)this.mapper.readValue(responseBody, RiskResult.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return this.defaultRiskResult;
        }
    }

    @Override
    public void sendAsync(final Event event, final String url) {
        if (this.options.getSdkEnabled() != null && !this.options.getSdkEnabled().booleanValue()) {
            return;
        }
        ((BoundRequestBuilder)this.asyncClient.setUrl(url)).setHeader((CharSequence)this.AUTHORIZATION, this.apiKey);
        try {
            this.asyncClient.setBody(this.mapper.writeValueAsString((Object)event));
        }
        catch (JsonProcessingException e) {
            Logger.getLogger().info(String.format("Secure Native async http call failed to end point: %s  with event type %s. error: %s", new Object[]{url, event.getEventType(), e}));
        }
        this.asyncClient.execute((AsyncHandler)new AsyncCompletionHandler<Object>(){

            public Object onCompleted(Response response) {
                if (response.getStatusCode() > SnEventManager.this.HTTP_STATUS_OK) {
                    Logger.getLogger().info(String.format("Secure Native http call failed to end point: %s  with event type %s. adding back to queue.", url, event.getEventType()));
                    SnEventManager.this.events.add(new Message(event, response.getUri().toUrl()));
                }
                return response;
            }
        });
    }

    @Override
    public String sendAgentEvent(Event event, String requestUrl) {
        ((BoundRequestBuilder)this.asyncClient.setHeader((CharSequence)this.AUTHORIZATION, this.apiKey)).setUrl(requestUrl);
        try {
            String responseBody;
            this.asyncClient.setBody(this.mapper.writeValueAsString((Object)event));
            Response response = (Response)this.asyncClient.execute().get();
            if (response == null || response.getStatusCode() > this.HTTP_STATUS_OK) {
                Logger.getLogger().info(String.format("Secure Native http call failed to end point: %s  with event type %s. adding back to queue.", requestUrl, event.getEventType()));
                assert (response != null);
                this.events.add(new Message(event, response.getUri().toUrl()));
            }
            if (Utils.isNullOrEmpty(responseBody = response.getResponseBody())) {
                Logger.getLogger().info(String.format("Secure Native http call to %s returned with empty response. returning default risk result.", requestUrl));
                return "";
            }
            Logger.getLogger().info(String.format("Secure Native http call to %s was successful.", requestUrl));
            return responseBody;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return "";
        }
    }

    private BoundRequestBuilder initializeAsyncHttpClient(SecureNativeOptions options) {
        DefaultAsyncHttpClientConfig.Builder clientBuilder = Dsl.config().setConnectTimeout((int)options.getTimeout()).setUserAgent("com.securenative.snlogic.SecureNative-java");
        AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)clientBuilder);
        Logger.getLogger().info("Initialized Http client");
        return (BoundRequestBuilder)((BoundRequestBuilder)client.preparePost(options.getApiUrl()).addHeader((CharSequence)"SN-Version", this.getVersion())).addHeader((CharSequence)"Accept", "application/json");
    }

    private String getVersion() {
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            String pomResource = "/META-INF/maven/com.securenative.java/sdk-base/pom.xml";
            Model read = reader.read((Reader)new InputStreamReader(SnEventManager.class.getResourceAsStream(pomResource)));
            return read.getParent().getVersion();
        }
        catch (Exception e) {
            return "unknown";
        }
    }
}

