/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.utils;

import com.securenative.Logger;
import com.securenative.exceptions.SecureNativeSDKException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Utils {
    private static String[] ipHeaders = new String[]{"x-forwarded-for", "x-client-ip", "x-real-ip", "x-forwarded", "x-cluster-client-ip", "forwarded-for", "forwarded", "via"};
    public String COOKIE_NAME = "_sn";
    public final String SN_HEADER = "x-securenative";
    public final String USERAGENT_HEADER = "user-agent";
    private final String HMAC_SHA1_ALGORITHM = "HmacSHA512";
    private Pattern VALID_IPV6_PATTERN = Pattern.compile("([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}", 2);
    private final int AES_KEY_SIZE = 32;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public String remoteIpFromRequest(Function<String, String> headerExtractor) {
        Logger.getLogger().info("Extracting remote ip from requests");
        Optional<Object> bestCandidate = Optional.empty();
        String header = "";
        for (int i = 0; i < ipHeaders.length; ++i) {
            List<String> candidates = Arrays.asList(new String[0]);
            header = headerExtractor.apply(ipHeaders[i]);
            if (!Utils.isNullOrEmpty(header) && (candidates = Arrays.stream(header.split(",")).map(s -> s.trim()).filter(s -> !Utils.isNullOrEmpty(s) && (this.isValidInet4Address((String)s) || this.isIpV6Address((String)s)) && !this.isPrivateIPAddress((String)s)).collect(Collectors.toList())).size() > 0) {
                Logger.getLogger().info(String.format("Extracted remote ip %s", candidates.get(0)));
                return candidates.get(0);
            }
            if (bestCandidate.isPresent()) continue;
            bestCandidate = candidates.stream().filter(x -> this.isLoopBack((String)x)).findFirst();
        }
        Logger.getLogger().info("couldn't extract remote ip, returning 127.0.0.1");
        return "127.0.0.1";
    }

    private boolean isLoopBack(String ip) {
        try {
            return InetAddress.getByName(ip).isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isPrivateIPAddress(String ipAddress) {
        InetAddress ia = null;
        try {
            InetAddress ad = InetAddress.getByName(ipAddress);
            byte[] ip = ad.getAddress();
            ia = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return ia.isSiteLocalAddress();
    }

    private String toHexString(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    private String calculateRFC2104HMAC(String data, String key) throws SecureNativeSDKException {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA512");
            Mac mac = Mac.getInstance("HmacSHA512");
            mac.init(signingKey);
            return this.toHexString(mac.doFinal(data.getBytes()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SecureNativeSDKException("failed calculating hmac");
        }
    }

    private String calculateSignature(String payload, String apikey) {
        if (Utils.isNullOrEmpty(payload)) {
            return null;
        }
        try {
            return this.calculateRFC2104HMAC(payload, apikey);
        }
        catch (SecureNativeSDKException e) {
            return null;
        }
    }

    public boolean isVerifiedSnRequest(String payload, String hedaerSignature, String apiKey) {
        String signed = this.calculateSignature(payload, apiKey);
        if (Utils.isNullOrEmpty(signed) || Utils.isNullOrEmpty(hedaerSignature)) {
            return false;
        }
        return hedaerSignature.equals(signed);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private boolean isValidInet4Address(String ip) {
        String[] groups = ip.split("\\.");
        if (groups.length != 4) {
            return false;
        }
        try {
            return Arrays.stream(groups).filter(s -> s.length() > 1 && s.startsWith("0")).map(Integer::parseInt).filter(i -> i >= 0 && i <= 255).count() == 4L;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isIpV6Address(String ipAddress) {
        return this.VALID_IPV6_PATTERN.matcher(ipAddress).matches();
    }

    public String decrypt(String s, String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        Logger.getLogger().info("Starting to decrypt " + s);
        if (s == null || s.length() == 0) {
            return s;
        }
        byte[] cipherText = this.hexToByteArray(s);
        SecretKeySpec skeySpec = new SecretKeySpec(key.substring(0, 32).getBytes("UTF-8"), "AES");
        byte[] ivBytes = Arrays.copyOfRange(cipherText, 0, 16);
        cipherText = Arrays.copyOfRange(cipherText, 16, cipherText.length);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec IVspec = new IvParameterSpec(ivBytes);
        cipher.init(2, (Key)skeySpec, IVspec);
        return new String(cipher.doFinal(cipherText), "UTF-8").trim();
    }

    private byte[] hexToByteArray(String s) {
        byte[] retValue = null;
        if (s != null && s.length() != 0) {
            retValue = new byte[s.length() / 2];
            for (int i = 0; i < retValue.length; ++i) {
                retValue[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
            }
        }
        return retValue;
    }

    private static String byteArrayToHex(byte[] byteArray) {
        StringBuffer hexBuffer = new StringBuffer(byteArray.length * 2);
        for (byte b : byteArray) {
            for (int j = 1; j >= 0; --j) {
                hexBuffer.append(HEX[b >> j * 4 & 0xF]);
            }
        }
        return hexBuffer.toString();
    }

    private byte[] pad(byte[] buf, int size) {
        int bufLen = buf.length;
        int padLen = size - bufLen % size;
        byte[] padded = new byte[bufLen + padLen];
        padded = Arrays.copyOf(buf, bufLen + padLen);
        for (int i = 0; i < padLen; ++i) {
            padded[bufLen + i] = (byte)padLen;
        }
        return padded;
    }

    public static String encrypt(String text, String key) throws UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] ivBytes = new byte[16];
        secureRandom.nextBytes(ivBytes);
        IvParameterSpec IVspec = new IvParameterSpec(ivBytes);
        SecretKeySpec skeySpec = new SecretKeySpec(key.substring(0, 32).getBytes(StandardCharsets.UTF_8), "AES");
        byte[] source = text.getBytes(StandardCharsets.UTF_8);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)skeySpec, IVspec);
        int mod = source.length % 16;
        if (mod != 0) {
            text = String.format(text + "%" + (16 - mod) + "s", " ");
        }
        return Utils.byteArrayToHex(cipher.doFinal(Utils.addAll(ivBytes, text.getBytes("UTF-8")))).trim();
    }

    private static byte[] addAll(byte[] array1, byte[] array2) {
        byte[] joinedArray = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    /*
     * Exception decompiling
     */
    public static int versionCompare(String str1, String str2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[WHILELOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

