/*
 * Decompiled with CFR 0.152.
 */
package com.shift4.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.shift4.exception.MappingException;
import com.shift4.response.ListResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class ObjectSerializer {
    public static final ObjectSerializer INSTANCE = new ObjectSerializer();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ObjectSerializer() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setVisibility(this.objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }

    public String serialize(Object request) {
        try {
            return this.objectMapper.writeValueAsString(request);
        }
        catch (JsonProcessingException e) {
            throw new MappingException(e);
        }
    }

    public <T> T deserialize(String responseBody, Class<T> responseClass) {
        return this.deserialize(responseBody, this.objectMapper.getTypeFactory().constructType(responseClass));
    }

    public <T> ListResponse<T> deserializeList(String responseBody, Class<T> elementClass) {
        return (ListResponse)this.deserialize(responseBody, this.objectMapper.getTypeFactory().constructParametricType(ListResponse.class, new Class[]{elementClass}));
    }

    private <T> T deserialize(String responseBody, JavaType responseType) {
        try {
            return (T)this.objectMapper.readValue(responseBody, responseType);
        }
        catch (IOException e) {
            throw new MappingException(e);
        }
    }

    public String serializeToQueryString(Object request) {
        ObjectNode node = (ObjectNode)this.objectMapper.valueToTree(request);
        if (node == null) {
            return "";
        }
        URIBuilder url = new URIBuilder();
        this.buildQueryString(url, null, node);
        return url.toString();
    }

    private void buildQueryString(URIBuilder url, String path, ObjectNode node) {
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry field = (Map.Entry)iterator.next();
            String fieldName = (String)field.getKey();
            JsonNode childNode = (JsonNode)field.getValue();
            if (childNode instanceof ObjectNode) {
                this.buildQueryString(url, this.getPath(path, fieldName), (ObjectNode)childNode);
                continue;
            }
            if (childNode instanceof ValueNode) {
                ValueNode valueNode = (ValueNode)childNode;
                if (valueNode.isNull()) continue;
                url.addParameter(this.getPath(path, fieldName), valueNode.asText());
                continue;
            }
            if (!(childNode instanceof ArrayNode)) continue;
            ArrayNode arrayNode = (ArrayNode)childNode;
            for (JsonNode jsonNode : arrayNode) {
                if (!(jsonNode instanceof TextNode)) continue;
                url.addParameter(this.getPath(path, fieldName) + "[]", jsonNode.asText());
            }
        }
    }

    private String getPath(String path, String fieldName) {
        if (path == null) {
            return fieldName;
        }
        return path + "[" + fieldName + "]";
    }
}

