/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.stackify.api.StackifyError;
import com.stackify.api.common.http.HttpTransmissionStatus;
import com.stackify.api.common.http.StackifyErrorSender;
import java.util.ArrayList;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncErrorSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncErrorSender.class);
    private final StackifyErrorSender errorSender;
    private final Queue<StackifyError> queue;

    public AsyncErrorSender(StackifyErrorSender errorSender, int queueMaxSize) {
        Preconditions.checkNotNull((Object)errorSender);
        Preconditions.checkArgument((0 < queueMaxSize ? 1 : 0) != 0, (Object)"Queue max size must be greater than zero");
        this.errorSender = errorSender;
        this.queue = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)queueMaxSize));
    }

    public void sendError(StackifyError error) {
        Preconditions.checkNotNull((Object)error);
        this.queue.offer(error);
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public HttpTransmissionStatus flush() {
        int batchSize;
        int maxToSend = this.queue.size();
        for (int numSent = 0; numSent < maxToSend; numSent += batchSize) {
            batchSize = Math.min(maxToSend - numSent, 10);
            ArrayList batch = Lists.newArrayListWithCapacity((int)batchSize);
            for (int i = 0; i < batchSize; ++i) {
                batch.add(this.queue.remove());
            }
            int httpStatus = 500;
            LOGGER.debug("Sending batch of {} error/s to Stackify", (Object)batchSize);
            try {
                httpStatus = this.errorSender.send(batch);
            }
            catch (Exception e) {
                LOGGER.info("Exception sending batch of errors to Stackify", (Throwable)e);
                return HttpTransmissionStatus.ERROR;
            }
            if (httpStatus == 200) continue;
            LOGGER.info("HTTP {} error sending batch of errors to Stackify", (Object)httpStatus);
            if (httpStatus == 401) {
                return HttpTransmissionStatus.UNAUTHORIZED;
            }
            return HttpTransmissionStatus.ERROR;
        }
        return HttpTransmissionStatus.OK;
    }
}

