/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.stackify.api.common.http.HttpTransmissionStatus;
import java.util.concurrent.TimeUnit;

public class AsyncScheduler
extends AbstractScheduledService.CustomScheduler {
    private int scheduleDelay = 1;
    private long lastHttpError = 0L;

    public void update(HttpTransmissionStatus status) {
        if (status == HttpTransmissionStatus.OK) {
            this.lastHttpError = 0L;
            this.scheduleDelay = 1;
        } else if (status == HttpTransmissionStatus.UNAUTHORIZED) {
            this.lastHttpError = System.currentTimeMillis();
            this.scheduleDelay = 300;
        } else {
            if (this.lastHttpError == 0L) {
                this.lastHttpError = System.currentTimeMillis();
            }
            int sinceFirstError = (int)Math.ceil((double)(System.currentTimeMillis() - this.lastHttpError) / 1000.0);
            this.scheduleDelay = Math.min(Math.max(sinceFirstError, 1), 60);
        }
    }

    public int getScheduleDelay() {
        return this.scheduleDelay;
    }

    public long getLastHttpError() {
        return this.lastHttpError;
    }

    protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() {
        return new AbstractScheduledService.CustomScheduler.Schedule((long)this.scheduleDelay, TimeUnit.SECONDS);
    }
}

