/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import com.google.common.base.Preconditions;
import com.stackify.api.StackifyError;
import com.stackify.api.common.http.HttpUrlConnections;
import com.stackify.api.json.StackifyErrorConverter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class StackifyErrorSender {
    private final String apiUrl;
    private final String apiKey;
    private final StackifyErrorConverter errorConverter;

    public StackifyErrorSender(String apiUrl, String apiKey, StackifyErrorConverter errorWriter) {
        Preconditions.checkNotNull((Object)errorWriter, (Object)"StackifyErrorConverter is null");
        Preconditions.checkNotNull((Object)apiUrl, (Object)"API URL is null");
        Preconditions.checkArgument((!apiUrl.isEmpty() ? 1 : 0) != 0, (Object)"API URL is empty");
        Preconditions.checkNotNull((Object)apiKey, (Object)"API key is null");
        Preconditions.checkArgument((!apiKey.isEmpty() ? 1 : 0) != 0, (Object)"API key is empty");
        this.apiUrl = apiUrl;
        this.apiKey = apiKey;
        this.errorConverter = errorWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(List<StackifyError> errors) throws IOException {
        int n;
        if (errors == null) {
            throw new NullPointerException("StackifyError list is null");
        }
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("StackifyError list is empty");
        }
        HttpURLConnection connection = null;
        try {
            URL url = new URL(this.apiUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Encoding", "gzip");
            connection.setRequestProperty("X-Stackify-Key", this.apiKey);
            connection.setRequestProperty("X-Stackify-PV", "V1");
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            BufferedOutputStream stream = new BufferedOutputStream(new GZIPOutputStream(connection.getOutputStream()));
            this.errorConverter.writeToStream(errors, (OutputStream)stream);
            ((OutputStream)stream).flush();
            ((OutputStream)stream).close();
            n = connection.getResponseCode();
        }
        catch (Throwable throwable) {
            HttpUrlConnections.readAndCloseInputStreams(connection);
            throw throwable;
        }
        HttpUrlConnections.readAndCloseInputStreams(connection);
        return n;
    }
}

