/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.lang;

import com.stackify.api.ErrorItem;
import com.stackify.api.TraceFrame;
import com.stackify.api.common.lang.StackTraceElements;
import java.util.ArrayList;
import java.util.List;

public class Throwables {
    public static List<Throwable> getCausalChain(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("Throwable is null");
        }
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        causes.add(throwable);
        for (Throwable cause = throwable.getCause(); cause != null && !causes.contains(cause); cause = cause.getCause()) {
            causes.add(cause);
        }
        return causes;
    }

    public static ErrorItem toErrorItem(String logMessage, Throwable t) {
        int i;
        List<Throwable> throwables = Throwables.getCausalChain(t);
        ArrayList<ErrorItem.Builder> builders = new ArrayList<ErrorItem.Builder>(throwables.size());
        for (i = 0; i < throwables.size(); ++i) {
            ErrorItem.Builder builder;
            if (i == 0) {
                builder = Throwables.toErrorItemBuilderWithoutCause(logMessage, throwables.get(i));
                builders.add(builder);
                continue;
            }
            builder = Throwables.toErrorItemBuilderWithoutCause(null, throwables.get(i));
            builders.add(builder);
        }
        for (i = builders.size() - 1; 0 < i; --i) {
            ErrorItem.Builder parent = (ErrorItem.Builder)builders.get(i - 1);
            ErrorItem.Builder child = (ErrorItem.Builder)builders.get(i);
            parent.innerError(child.build());
        }
        return ((ErrorItem.Builder)builders.get(0)).build();
    }

    public static ErrorItem toErrorItem(Throwable t) {
        return Throwables.toErrorItem(null, t);
    }

    private static ErrorItem.Builder toErrorItemBuilderWithoutCause(String logMessage, Throwable t) {
        ErrorItem.Builder builder = ErrorItem.newBuilder();
        builder.message(Throwables.toErrorItemMessage(logMessage, t.getMessage()));
        builder.errorType(t.getClass().getCanonicalName());
        ArrayList<TraceFrame> stackFrames = new ArrayList<TraceFrame>();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace != null && 0 < stackTrace.length) {
            StackTraceElement firstFrame = stackTrace[0];
            builder.sourceMethod(firstFrame.getClassName() + "." + firstFrame.getMethodName());
            for (int i = 0; i < stackTrace.length; ++i) {
                TraceFrame stackFrame = StackTraceElements.toTraceFrame(stackTrace[i]);
                stackFrames.add(stackFrame);
            }
        }
        builder.stackTrace(stackFrames);
        return builder;
    }

    private static String toErrorItemMessage(String logMessage, String throwableMessage) {
        StringBuilder sb = new StringBuilder();
        if (throwableMessage != null && !throwableMessage.isEmpty()) {
            sb.append(throwableMessage);
            if (logMessage != null && !logMessage.isEmpty()) {
                sb.append(" (");
                sb.append(logMessage);
                sb.append(")");
            }
        } else {
            sb.append(logMessage);
        }
        return sb.toString();
    }

    private Throwables() {
    }
}

