/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.stackify.api.AppIdentity;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.http.HttpClient;
import com.stackify.api.common.http.HttpException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppIdentityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppIdentityService.class);
    private static long FIVE_MINUTES_MILLIS = 300000L;
    private long lastQuery = 0L;
    private Optional<AppIdentity> appIdentity = Optional.absent();
    private final ApiConfiguration apiConfig;
    private final ObjectMapper objectMapper;

    public AppIdentityService(ApiConfiguration apiConfig, ObjectMapper objectMapper) {
        Preconditions.checkNotNull((Object)apiConfig);
        Preconditions.checkNotNull((Object)objectMapper);
        this.apiConfig = apiConfig;
        this.objectMapper = objectMapper;
    }

    public Optional<AppIdentity> getAppIdentity() {
        long currentTimeMillis;
        if (!this.appIdentity.isPresent() && this.lastQuery + FIVE_MINUTES_MILLIS < (currentTimeMillis = System.currentTimeMillis())) {
            try {
                this.lastQuery = currentTimeMillis;
                this.appIdentity = Optional.fromNullable((Object)this.identifyApp());
                LOGGER.debug("Application identity: {}", this.appIdentity.get());
            }
            catch (Throwable t) {
                LOGGER.info("Unable to determine application identity", t);
            }
        }
        return this.appIdentity;
    }

    private AppIdentity identifyApp() throws IOException, HttpException {
        byte[] jsonBytes = this.objectMapper.writer().writeValueAsBytes((Object)this.apiConfig.getEnvDetail());
        HttpClient httpClient = new HttpClient(this.apiConfig);
        String responseString = httpClient.post("/Metrics/IdentifyApp", jsonBytes);
        ObjectReader jsonReader = this.objectMapper.reader((TypeReference)new TypeReference<AppIdentity>(){});
        AppIdentity appIdentity = (AppIdentity)jsonReader.readValue(responseString);
        return appIdentity;
    }
}

