/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.error;

import com.stackify.api.ErrorItem;
import com.stackify.api.StackifyError;
import com.stackify.api.common.codec.MessageDigests;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ErrorCounter {
    private final Map<String, MinuteCounter> errorCounter = new HashMap<String, MinuteCounter>();

    public static ErrorItem getBaseError(StackifyError error) {
        if (error == null) {
            throw new NullPointerException("StackifyError is null");
        }
        ErrorItem errorItem = error.getError();
        if (errorItem != null) {
            while (errorItem.getInnerError() != null) {
                errorItem = errorItem.getInnerError();
            }
        }
        return errorItem;
    }

    public static String getUniqueKey(ErrorItem errorItem) {
        if (errorItem == null) {
            throw new NullPointerException("ErrorItem is null");
        }
        String type = errorItem.getErrorType();
        String typeCode = errorItem.getErrorTypeCode();
        String method = errorItem.getSourceMethod();
        String uniqueKey = String.format("%s-%s-%s", type, typeCode, method);
        return MessageDigests.md5Hex(uniqueKey);
    }

    public int incrementCounter(StackifyError error, long epochMinute) {
        if (error == null) {
            throw new NullPointerException("StackifyError is null");
        }
        ErrorItem baseError = ErrorCounter.getBaseError(error);
        String uniqueKey = ErrorCounter.getUniqueKey(baseError);
        int count = 0;
        if (this.errorCounter.containsKey(uniqueKey)) {
            MinuteCounter counter = this.errorCounter.get(uniqueKey);
            if (counter.getEpochMinute() == epochMinute) {
                MinuteCounter incCounter = MinuteCounter.incrementCounter(counter);
                this.errorCounter.put(uniqueKey, incCounter);
                count = incCounter.getErrorCount();
            } else {
                MinuteCounter newCounter = MinuteCounter.newMinuteCounter(epochMinute);
                this.errorCounter.put(uniqueKey, newCounter);
                count = newCounter.getErrorCount();
            }
        } else {
            MinuteCounter newCounter = MinuteCounter.newMinuteCounter(epochMinute);
            this.errorCounter.put(uniqueKey, newCounter);
            count = newCounter.getErrorCount();
        }
        return count;
    }

    public void purgeCounters(long epochMinute) {
        Iterator<Map.Entry<String, MinuteCounter>> it = this.errorCounter.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MinuteCounter> entry = it.next();
            if (entry.getValue().getEpochMinute() >= epochMinute) continue;
            it.remove();
        }
    }

    protected static class MinuteCounter {
        private final long epochMinute;
        private final int errorCount;

        public static MinuteCounter newMinuteCounter(long epochMinute) {
            return new MinuteCounter(epochMinute, 1);
        }

        public static MinuteCounter incrementCounter(MinuteCounter counter) {
            return new MinuteCounter(counter.epochMinute, counter.errorCount + 1);
        }

        private MinuteCounter(long epochMinute, int errorCount) {
            this.epochMinute = epochMinute;
            this.errorCount = errorCount;
        }

        public long getEpochMinute() {
            return this.epochMinute;
        }

        public int getErrorCount() {
            return this.errorCount;
        }
    }
}

