/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import lombok.NonNull;
import org.slf4j.helpers.SubstituteLogger;

public final class StackTraceUtil {
    private static final Class[] skipClasses = new Class[]{SubstituteLogger.class, Throwable.class};

    public static StackTraceElement getStackTraceElement(StackTraceElement[] stackTraceElements) {
        if (stackTraceElements != null) {
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                String classname;
                if (stackTraceElement == null || StackTraceUtil.skipClass(classname = stackTraceElement.getClassName())) continue;
                return stackTraceElement;
            }
        }
        return null;
    }

    public static String getClassName(StackTraceElement[] stackTraceElements) {
        StackTraceElement stackTraceElement = StackTraceUtil.getStackTraceElement(stackTraceElements);
        if (stackTraceElement != null) {
            return stackTraceElement.getClassName();
        }
        return null;
    }

    private static boolean skipClass(@NonNull String classname) {
        if (classname == null) {
            throw new NullPointerException("classname is marked non-null but is null");
        }
        for (Class skipClass : skipClasses) {
            if (!skipClass.getName().equalsIgnoreCase(classname)) continue;
            return true;
        }
        return false;
    }

    private StackTraceUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

