/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.error.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import com.stackify.api.ApiClient;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.StackifyError;
import com.stackify.api.common.ApiClients;
import com.stackify.api.common.EnvironmentDetails;
import com.stackify.api.common.error.ErrorGovernor;
import com.stackify.api.common.http.AsyncErrorSender;
import com.stackify.api.common.http.AsyncErrorSenderService;
import com.stackify.api.common.http.AsyncScheduler;
import com.stackify.api.common.http.StackifyErrorSender;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.json.StackifyErrorConverter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StackifyErrorAppender
extends AppenderBase<ILoggingEvent> {
    private static final int MAX_QUEUE_SIZE = 1000;
    private ErrorGovernor errorGovernor = new ErrorGovernor();
    private AsyncErrorSender asyncErrorSender = null;
    private AsyncErrorSenderService asyncErrorSenderService = null;
    private ApiClient apiClient = null;
    private EnvironmentDetail environmentDetail = null;
    private String apiUrl = "https://api.stackify.com/Error/V1";
    private String apiKey = null;
    private String application = null;
    private String environment = null;
    private String converter = "com.stackify.api.json.jackson.StackifyErrorJacksonConverter";

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getConverter() {
        return this.converter;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    protected ApiClient getApiClient() {
        return this.apiClient;
    }

    protected EnvironmentDetail getEnvironmentDetail() {
        return this.environmentDetail;
    }

    public boolean asyncErrorSenderServiceIsRunning() {
        if (this.asyncErrorSenderService != null) {
            return this.asyncErrorSenderService.isRunning();
        }
        return false;
    }

    public void start() {
        super.start();
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            this.addError("API Key not set for the Stackify Error Appender");
            return;
        }
        this.apiClient = ApiClients.getApiClient(StackifyErrorAppender.class, (String)"/stackify-error-logback.properties");
        this.environmentDetail = EnvironmentDetails.getEnvironmentDetail((String)this.application, (String)this.environment);
        try {
            Class<?> converterClass = Class.forName(this.converter);
            StackifyErrorConverter converterInstance = (StackifyErrorConverter)converterClass.newInstance();
            StackifyErrorSender errorSender = new StackifyErrorSender(this.apiUrl, this.apiKey, converterInstance);
            this.asyncErrorSender = new AsyncErrorSender(errorSender, 1000);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.asyncErrorSenderService = new AsyncErrorSenderService(new AsyncScheduler(), this.asyncErrorSender);
        try {
            this.asyncErrorSenderService.startAsync().awaitRunning(5L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            this.addInfo("Exception starting the Stackify_AsyncErrorSenderService", t);
        }
    }

    protected void append(ILoggingEvent event) {
        if (this.asyncErrorSender == null) {
            return;
        }
        Throwable exception = this.getThrowable(event);
        if (exception == null) {
            if (event.getLevel() == Level.ERROR) {
                exception = new Throwable();
            } else {
                return;
            }
        }
        try {
            StackifyError error;
            ArrayList<String> tags = new ArrayList<String>();
            tags.add("logback");
            tags.add(event.getLevel().toString().toLowerCase());
            tags.add(event.getLoggerName());
            StackifyError.Builder errorBuilder = StackifyError.newBuilder();
            errorBuilder.apiClient(this.apiClient);
            errorBuilder.environmentDetail(this.environmentDetail);
            errorBuilder.occurredEpochMillis(new Date(event.getTimeStamp()));
            errorBuilder.error(Throwables.toErrorItem((String)event.getFormattedMessage(), (Throwable)exception));
            errorBuilder.tags(tags);
            Map mdcProperties = event.getMDCPropertyMap();
            if (mdcProperties != null && !mdcProperties.isEmpty()) {
                errorBuilder.customProperties(mdcProperties);
            }
            if (this.errorGovernor.errorShouldBeSent(error = errorBuilder.build())) {
                this.asyncErrorSender.sendError(error);
            }
        }
        catch (Throwable t) {
            this.addInfo("Exception posting to Stackify Error Service", t);
        }
    }

    private Throwable getThrowable(ILoggingEvent event) {
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null && iThrowableProxy instanceof ThrowableProxy) {
            ThrowableProxy throwableProxy = (ThrowableProxy)iThrowableProxy;
            return throwableProxy.getThrowable();
        }
        return null;
    }

    public void stop() {
        if (this.asyncErrorSenderService != null) {
            try {
                this.asyncErrorSenderService.stopAsync().awaitTerminated(5L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                this.addInfo("Exception stopping the Stackify_AsyncErrorSenderService", t);
            }
        }
        super.stop();
    }
}

