/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.HRISGroupSourceValue;
import com.stackone.stackone_client_java.models.components.HRISGroupValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class HRISGroupType {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends HRISGroupValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends HRISGroupSourceValue> sourceValue;

    @JsonCreator
    public HRISGroupType(@JsonProperty(value="value") JsonNullable<? extends HRISGroupValue> value, @JsonProperty(value="source_value") JsonNullable<? extends HRISGroupSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public HRISGroupType() {
        this((JsonNullable<? extends HRISGroupValue>)JsonNullable.undefined(), (JsonNullable<? extends HRISGroupSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<HRISGroupValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<HRISGroupSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HRISGroupType withValue(HRISGroupValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public HRISGroupType withValue(JsonNullable<? extends HRISGroupValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public HRISGroupType withSourceValue(HRISGroupSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public HRISGroupType withSourceValue(JsonNullable<? extends HRISGroupSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HRISGroupType other = (HRISGroupType)o;
        return Objects.deepEquals(this.value, other.value) && Objects.deepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(HRISGroupType.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends HRISGroupValue> value = JsonNullable.undefined();
        private JsonNullable<? extends HRISGroupSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(HRISGroupValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends HRISGroupValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(HRISGroupSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends HRISGroupSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public HRISGroupType build() {
            return new HRISGroupType(this.value, this.sourceValue);
        }
    }
}

