/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class RawResponse {
    @JsonProperty(value="method")
    private String method;
    @JsonProperty(value="url")
    private String url;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="body")
    private JsonNullable<String> body;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="response")
    private JsonNullable<? extends Map<String, Object>> response;

    @JsonCreator
    public RawResponse(@JsonProperty(value="method") String method, @JsonProperty(value="url") String url, @JsonProperty(value="body") JsonNullable<String> body, @JsonProperty(value="response") JsonNullable<? extends Map<String, Object>> response) {
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(body, "body");
        Utils.checkNotNull(response, "response");
        this.method = method;
        this.url = url;
        this.body = body;
        this.response = response;
    }

    public RawResponse(String method, String url) {
        this(method, url, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String method() {
        return this.method;
    }

    @JsonIgnore
    public String url() {
        return this.url;
    }

    @JsonIgnore
    public JsonNullable<String> body() {
        return this.body;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> response() {
        return this.response;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public RawResponse withMethod(String method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    public RawResponse withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public RawResponse withBody(String body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of((Object)body);
        return this;
    }

    public RawResponse withBody(JsonNullable<String> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public RawResponse withResponse(Map<String, Object> response) {
        Utils.checkNotNull(response, "response");
        this.response = JsonNullable.of(response);
        return this;
    }

    public RawResponse withResponse(JsonNullable<? extends Map<String, Object>> response) {
        Utils.checkNotNull(response, "response");
        this.response = response;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawResponse other = (RawResponse)o;
        return Objects.deepEquals(this.method, other.method) && Objects.deepEquals(this.url, other.url) && Objects.deepEquals(this.body, other.body) && Objects.deepEquals(this.response, other.response);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.url, this.body, this.response);
    }

    public String toString() {
        return Utils.toString(RawResponse.class, "method", this.method, "url", this.url, "body", this.body, "response", this.response);
    }

    public static final class Builder {
        private String method;
        private String url;
        private JsonNullable<String> body = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> response = JsonNullable.undefined();

        private Builder() {
        }

        public Builder method(String method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder body(String body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of((Object)body);
            return this;
        }

        public Builder body(JsonNullable<String> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }

        public Builder response(Map<String, Object> response) {
            Utils.checkNotNull(response, "response");
            this.response = JsonNullable.of(response);
            return this;
        }

        public Builder response(JsonNullable<? extends Map<String, Object>> response) {
            Utils.checkNotNull(response, "response");
            this.response = response;
            return this;
        }

        public RawResponse build() {
            return new RawResponse(this.method, this.url, this.body, this.response);
        }
    }
}

