/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ScreeningOrderCandidate;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

public class ScreeningCreateOrderRequestDto {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;
    @JsonProperty(value="package_id")
    private String packageId;
    @JsonProperty(value="candidate")
    private ScreeningOrderCandidate candidate;

    @JsonCreator
    public ScreeningCreateOrderRequestDto(@JsonProperty(value="passthrough") JsonNullable<? extends Map<String, Object>> passthrough, @JsonProperty(value="unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields, @JsonProperty(value="package_id") String packageId, @JsonProperty(value="candidate") ScreeningOrderCandidate candidate) {
        Utils.checkNotNull(passthrough, "passthrough");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(packageId, "packageId");
        Utils.checkNotNull(candidate, "candidate");
        this.passthrough = passthrough;
        this.unifiedCustomFields = unifiedCustomFields;
        this.packageId = packageId;
        this.candidate = candidate;
    }

    public ScreeningCreateOrderRequestDto(String packageId, ScreeningOrderCandidate candidate) {
        this((JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), packageId, candidate);
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return this.passthrough;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return this.unifiedCustomFields;
    }

    @JsonIgnore
    public String packageId() {
        return this.packageId;
    }

    @JsonIgnore
    public ScreeningOrderCandidate candidate() {
        return this.candidate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ScreeningCreateOrderRequestDto withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    public ScreeningCreateOrderRequestDto withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }

    public ScreeningCreateOrderRequestDto withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    public ScreeningCreateOrderRequestDto withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    public ScreeningCreateOrderRequestDto withPackageId(String packageId) {
        Utils.checkNotNull(packageId, "packageId");
        this.packageId = packageId;
        return this;
    }

    public ScreeningCreateOrderRequestDto withCandidate(ScreeningOrderCandidate candidate) {
        Utils.checkNotNull(candidate, "candidate");
        this.candidate = candidate;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreeningCreateOrderRequestDto other = (ScreeningCreateOrderRequestDto)o;
        return Utils.enhancedDeepEquals(this.passthrough, other.passthrough) && Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) && Utils.enhancedDeepEquals(this.packageId, other.packageId) && Utils.enhancedDeepEquals(this.candidate, other.candidate);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.passthrough, this.unifiedCustomFields, this.packageId, this.candidate);
    }

    public String toString() {
        return Utils.toString(ScreeningCreateOrderRequestDto.class, "passthrough", this.passthrough, "unifiedCustomFields", this.unifiedCustomFields, "packageId", this.packageId, "candidate", this.candidate);
    }

    public static final class Builder {
        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
        private String packageId;
        private ScreeningOrderCandidate candidate;

        private Builder() {
        }

        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }

        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        public Builder packageId(String packageId) {
            Utils.checkNotNull(packageId, "packageId");
            this.packageId = packageId;
            return this;
        }

        public Builder candidate(ScreeningOrderCandidate candidate) {
            Utils.checkNotNull(candidate, "candidate");
            this.candidate = candidate;
            return this;
        }

        public ScreeningCreateOrderRequestDto build() {
            return new ScreeningCreateOrderRequestDto(this.passthrough, this.unifiedCustomFields, this.packageId, this.candidate);
        }
    }
}

