/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingCreateConversationRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;

public class MessagingCreateConversationRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private MessagingCreateConversationRequestDto messagingCreateConversationRequestDto;

    @JsonCreator
    public MessagingCreateConversationRequest(String xAccountId, MessagingCreateConversationRequestDto messagingCreateConversationRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(messagingCreateConversationRequestDto, "messagingCreateConversationRequestDto");
        this.xAccountId = xAccountId;
        this.messagingCreateConversationRequestDto = messagingCreateConversationRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public MessagingCreateConversationRequestDto messagingCreateConversationRequestDto() {
        return this.messagingCreateConversationRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessagingCreateConversationRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MessagingCreateConversationRequest withMessagingCreateConversationRequestDto(MessagingCreateConversationRequestDto messagingCreateConversationRequestDto) {
        Utils.checkNotNull(messagingCreateConversationRequestDto, "messagingCreateConversationRequestDto");
        this.messagingCreateConversationRequestDto = messagingCreateConversationRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingCreateConversationRequest other = (MessagingCreateConversationRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.messagingCreateConversationRequestDto, other.messagingCreateConversationRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.messagingCreateConversationRequestDto);
    }

    public String toString() {
        return Utils.toString(MessagingCreateConversationRequest.class, "xAccountId", this.xAccountId, "messagingCreateConversationRequestDto", this.messagingCreateConversationRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private MessagingCreateConversationRequestDto messagingCreateConversationRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder messagingCreateConversationRequestDto(MessagingCreateConversationRequestDto messagingCreateConversationRequestDto) {
            Utils.checkNotNull(messagingCreateConversationRequestDto, "messagingCreateConversationRequestDto");
            this.messagingCreateConversationRequestDto = messagingCreateConversationRequestDto;
            return this;
        }

        public MessagingCreateConversationRequest build() {
            return new MessagingCreateConversationRequest(this.xAccountId, this.messagingCreateConversationRequestDto);
        }
    }
}

