/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ScreeningPackagesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ScreeningListScreeningPackagesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ScreeningPackagesPaginated> screeningPackagesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public ScreeningListScreeningPackagesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ScreeningPackagesPaginated> screeningPackagesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(screeningPackagesPaginated, "screeningPackagesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.screeningPackagesPaginated = screeningPackagesPaginated;
        this.headers = headers;
    }

    public ScreeningListScreeningPackagesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ScreeningPackagesPaginated> screeningPackagesPaginated() {
        return this.screeningPackagesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ScreeningListScreeningPackagesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ScreeningListScreeningPackagesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ScreeningListScreeningPackagesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ScreeningListScreeningPackagesResponse withScreeningPackagesPaginated(ScreeningPackagesPaginated screeningPackagesPaginated) {
        Utils.checkNotNull(screeningPackagesPaginated, "screeningPackagesPaginated");
        this.screeningPackagesPaginated = Optional.ofNullable(screeningPackagesPaginated);
        return this;
    }

    public ScreeningListScreeningPackagesResponse withScreeningPackagesPaginated(Optional<? extends ScreeningPackagesPaginated> screeningPackagesPaginated) {
        Utils.checkNotNull(screeningPackagesPaginated, "screeningPackagesPaginated");
        this.screeningPackagesPaginated = screeningPackagesPaginated;
        return this;
    }

    public ScreeningListScreeningPackagesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreeningListScreeningPackagesResponse other = (ScreeningListScreeningPackagesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.screeningPackagesPaginated, other.screeningPackagesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.screeningPackagesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(ScreeningListScreeningPackagesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "screeningPackagesPaginated", this.screeningPackagesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ScreeningPackagesPaginated> screeningPackagesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder screeningPackagesPaginated(ScreeningPackagesPaginated screeningPackagesPaginated) {
            Utils.checkNotNull(screeningPackagesPaginated, "screeningPackagesPaginated");
            this.screeningPackagesPaginated = Optional.ofNullable(screeningPackagesPaginated);
            return this;
        }

        public Builder screeningPackagesPaginated(Optional<? extends ScreeningPackagesPaginated> screeningPackagesPaginated) {
            Utils.checkNotNull(screeningPackagesPaginated, "screeningPackagesPaginated");
            this.screeningPackagesPaginated = screeningPackagesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public ScreeningListScreeningPackagesResponse build() {
            return new ScreeningListScreeningPackagesResponse(this.contentType, this.statusCode, this.rawResponse, this.screeningPackagesPaginated, this.headers);
        }
    }
}

