/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.UnifiedUploadRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class DocumentsUploadFileRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-stackone-api-session-token")
    private Optional<String> xStackoneApiSessionToken;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private UnifiedUploadRequestDto unifiedUploadRequestDto;

    @JsonCreator
    public DocumentsUploadFileRequest(String xAccountId, Optional<String> xStackoneApiSessionToken, UnifiedUploadRequestDto unifiedUploadRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
        this.xAccountId = xAccountId;
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        this.unifiedUploadRequestDto = unifiedUploadRequestDto;
    }

    public DocumentsUploadFileRequest(String xAccountId, UnifiedUploadRequestDto unifiedUploadRequestDto) {
        this(xAccountId, Optional.empty(), unifiedUploadRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> xStackoneApiSessionToken() {
        return this.xStackoneApiSessionToken;
    }

    @JsonIgnore
    public UnifiedUploadRequestDto unifiedUploadRequestDto() {
        return this.unifiedUploadRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DocumentsUploadFileRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public DocumentsUploadFileRequest withXStackoneApiSessionToken(String xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
        return this;
    }

    public DocumentsUploadFileRequest withXStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        return this;
    }

    public DocumentsUploadFileRequest withUnifiedUploadRequestDto(UnifiedUploadRequestDto unifiedUploadRequestDto) {
        Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
        this.unifiedUploadRequestDto = unifiedUploadRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentsUploadFileRequest other = (DocumentsUploadFileRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.xStackoneApiSessionToken, other.xStackoneApiSessionToken) && Utils.enhancedDeepEquals(this.unifiedUploadRequestDto, other.unifiedUploadRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.xStackoneApiSessionToken, this.unifiedUploadRequestDto);
    }

    public String toString() {
        return Utils.toString(DocumentsUploadFileRequest.class, "xAccountId", this.xAccountId, "xStackoneApiSessionToken", this.xStackoneApiSessionToken, "unifiedUploadRequestDto", this.unifiedUploadRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> xStackoneApiSessionToken = Optional.empty();
        private UnifiedUploadRequestDto unifiedUploadRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder xStackoneApiSessionToken(String xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
            return this;
        }

        public Builder xStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = xStackoneApiSessionToken;
            return this;
        }

        public Builder unifiedUploadRequestDto(UnifiedUploadRequestDto unifiedUploadRequestDto) {
            Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
            this.unifiedUploadRequestDto = unifiedUploadRequestDto;
            return this;
        }

        public DocumentsUploadFileRequest build() {
            return new DocumentsUploadFileRequest(this.xAccountId, this.xStackoneApiSessionToken, this.unifiedUploadRequestDto);
        }
    }
}

